/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.umpay.sdk.client.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fshows.umpay.sdk.client.UploadPictureClient;
import com.fshows.umpay.sdk.enums.UmPictureApiEnum;
import com.fshows.umpay.sdk.exception.UmPayException;
import com.fshows.umpay.sdk.request.picture.AggregationFilesUploadDirectBase64Request;
import com.fshows.umpay.sdk.request.picture.FilesUploadDirectRequest;
import com.fshows.umpay.sdk.request.picture.item.FilesUploadDirectBase64ItemRequest;
import com.fshows.umpay.sdk.response.picture.item.FileInfoItemResponse;
import com.fshows.umpay.sdk.util.FsHttpUtil;
import com.fshows.umpay.sdk.util.SignUtil;
import java.net.URI;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadPictureClientImpl
implements UploadPictureClient {
    private static final Logger log = LoggerFactory.getLogger(UploadPictureClientImpl.class);
    private static final String VERSION = "1.0";

    @Override
    public FileInfoItemResponse upload(FilesUploadDirectRequest request) throws UmPayException {
        long beginTime = System.currentTimeMillis();
        log.info("\u3010umpay-sdk\u3011>> \u56fe\u7247\u4e0a\u4f20\u5f00\u59cb request={},begin={}", (Object)request, (Object)beginTime);
        String uploadUrl = request.getUploadUrl();
        String pictureUrl = request.getPictureUrl();
        if (StringUtils.isBlank((CharSequence)uploadUrl) || StringUtils.isBlank((CharSequence)pictureUrl)) {
            throw new IllegalArgumentException("\u4e0a\u4f20\u548c\u4e0b\u8f7d\u5730\u5740\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            HttpResponse httpResponse;
            String path = new URI(pictureUrl).getPath();
            int index = path.lastIndexOf(".");
            String suffix = "png";
            if (index > 0) {
                suffix = StringUtils.substring((String)path, (int)(index + 1));
            }
            if (!(httpResponse = HttpUtil.createGet((String)pictureUrl).executeAsync()).isOk()) {
                throw new HttpException("Server response error with status code: [{}]", new Object[]{httpResponse.getStatus()});
            }
            String pictureBase64 = Base64.getEncoder().encode(httpResponse.bodyBytes()).toString();
            FilesUploadDirectBase64ItemRequest itemRequest = new FilesUploadDirectBase64ItemRequest();
            itemRequest.setFile(pictureBase64);
            itemRequest.setMineType(suffix);
            itemRequest.setRemarks(suffix);
            AggregationFilesUploadDirectBase64Request base64Request = new AggregationFilesUploadDirectBase64Request();
            base64Request.setFileList(Collections.singletonList(itemRequest));
            Map<String, String> requestData = this.getRequestData(request, UmPictureApiEnum.AGGREGATION_FILES_UPLOAD_DIRECT_BASE64.getValue(), request.getAppId(), request.getFbPrivateKey());
            String result = FsHttpUtil.post(uploadUrl, requestData);
            log.info("\u3010umpay-sdk\u3011 >> \u56fe\u7247\u4e0a\u4f20\u7ed3\u675f >> request={},requestData={},result={},cost={}", new Object[]{request, requestData, result, System.currentTimeMillis() - beginTime});
            if (StringUtils.isBlank((CharSequence)result)) {
                log.warn("\u3010umpay-sdk\u3011 >> \u56fe\u7247\u4e0a\u4f20\u5931\u8d25 >> request={},requestData={},result={}", new Object[]{request, requestData, result});
                throw new UmPayException("\u56fe\u7247\u4e0a\u4f20\u5931\u8d25");
            }
            JSONObject resultObject = JSONObject.parseObject((String)result);
            Boolean success = resultObject.getBoolean("success");
            if (ObjectUtil.isNull((Object)success) || !success.booleanValue()) {
                log.warn("\u3010umpay-sdk\u3011 >> \u56fe\u7247\u4e0a\u4f20\u5931\u8d25 >> request={},requestData={},result={}", new Object[]{request, requestData, result});
                String errorCode = resultObject.getString("error_code");
                String errorMsg = resultObject.getString("error_message");
                throw new UmPayException(StrUtil.format((CharSequence)"[{}]{}", (Object[])new Object[]{errorCode, errorMsg}));
            }
            List fileInfoItemResponses = JSON.parseArray((String)resultObject.getString("return_value"), FileInfoItemResponse.class);
            return (FileInfoItemResponse)fileInfoItemResponses.get(0);
        }
        catch (Exception e) {
            log.error("\u3010umpay-sdk\u3011 >> \u56fe\u7247\u4e0a\u4f20\u5f02\u5e38 >> request={},e={},cost={}", new Object[]{request, e, System.currentTimeMillis() - beginTime});
            throw new UmPayException(e.getMessage(), e);
        }
    }

    private Map<String, String> getRequestData(FilesUploadDirectRequest request, String method, String appId, String fbPrivateKey) {
        HashMap<String, String> signMap = new HashMap<String, String>(16);
        signMap.put("app_id", appId);
        signMap.put("method", method);
        signMap.put("version", VERSION);
        signMap.put("content", JSON.toJSONString((Object)request));
        String sign = SignUtil.sign(signMap, "RSA", fbPrivateKey);
        signMap.put("sign", sign);
        return signMap;
    }
}

