/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.umpay.sdk.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fshows.umpay.sdk.client.UmBaseClient;
import com.fshows.umpay.sdk.exception.UmPayException;
import com.fshows.umpay.sdk.request.UmBizRequest;
import com.fshows.umpay.sdk.response.UmBaseResponse;
import com.fshows.umpay.sdk.util.FsHttpUtil;
import com.fshows.umpay.sdk.util.SignUtil;
import com.fshows.umpay.sdk.util.ValidateUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UmBaseClientImpl
implements UmBaseClient {
    private static final Logger log = LoggerFactory.getLogger(UmBaseClientImpl.class);
    private static final String VERSION = "1.0";
    private String appId;
    private String fbPrivateKey;
    private String umPublicKey;

    public UmBaseClientImpl(String appId, String fbPrivateKey, String umPublicKey) {
        this.appId = appId;
        this.fbPrivateKey = fbPrivateKey;
        this.umPublicKey = umPublicKey;
    }

    @Override
    public <R> UmBaseResponse<R> excute(UmBizRequest<R> request, String method, String postUrl) throws UmPayException {
        this.validateParam(request, method);
        long startTime = System.currentTimeMillis();
        Map<String, String> requestData = this.getRequestData(request, method, true);
        log.info("\u3010umpay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u5f00\u59cb >> url={},method={},request={}", new Object[]{postUrl, method, requestData});
        try {
            String result = FsHttpUtil.post(postUrl, requestData);
            log.info("\u3010umpay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u7ed3\u675f >> url={},method={},request={},response={},cost={}", new Object[]{postUrl, method, requestData, result, System.currentTimeMillis() - startTime});
            return this.parseResponse(result, request);
        }
        catch (Exception ex) {
            log.error("\u3010umpay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u5931\u8d25 >> url={},method={},request={},ex={},cost={}", new Object[]{postUrl, method, requestData, ExceptionUtils.getStackTrace((Throwable)ex), System.currentTimeMillis() - startTime});
            throw new UmPayException(ex.getMessage());
        }
    }

    private <R> void validateParam(UmBizRequest<R> request, String method) {
        if (request == null) {
            throw new IllegalArgumentException("\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.fbPrivateKey)) {
            throw new IllegalArgumentException("\u79c1\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.umPublicKey)) {
            throw new IllegalArgumentException("\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)method)) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ValidateUtil.validateWithThrow(request, new Class[0]);
    }

    private <R> Map<String, String> getRequestData(UmBizRequest<R> request, String method, boolean isSign) {
        HashMap<String, String> signMap = new HashMap<String, String>(16);
        signMap.put("app_id", this.appId);
        signMap.put("method", method);
        signMap.put("version", VERSION);
        signMap.put("content", JSON.toJSONString(request));
        if (isSign) {
            String sign = SignUtil.sign(signMap, "RSA", this.fbPrivateKey);
            signMap.put("sign", sign);
        }
        return signMap;
    }

    private <R> UmBaseResponse<R> parseResponse(String result, UmBizRequest<R> request) {
        JSONObject jsonObject = JSON.parseObject((String)result);
        UmBaseResponse<Object> response = new UmBaseResponse<Object>();
        response.setSuccess(jsonObject.getBoolean("success"));
        response.setErrorCode(jsonObject.getString("error_code"));
        response.setErrorMessage(jsonObject.getString("error_message"));
        response.setReturnValue(JSON.parseObject((String)jsonObject.getString("return_value"), request.getResponseClass()));
        return response;
    }
}

