/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.response.picture.item;

import lombok.Data;

import java.io.Serializable;

/**
 * @author youmingming
 * @version FileInfoResponse.java, v 0.1 2022-02-10 上午10:28 youmingming
 */
@Data
public class FileInfoResponse implements Serializable {

    private static final long serialVersionUID = -4962118845143787157L;

    /**
     * 文件ID，系统内唯一
     */
    private String fileId;

    /**
     * 上传的文件URL
     */
    private String url;

    /**
     * 文件备注，图片批量上传接口中的备注原样返回
     */
    private String memo;

    /**
     * 图片是否已使用：1-已使用; 0-未使用
     */
    private String isUse;

    /**
     * 上传成功，或者返回上传失败的原因
     */
    private String failReason;

    /**
     * 图片状态：1-上传成功; 2-上传失败
     */
    private String status;
}