/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.umpay.sdk.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @author youmingming
 * @version UmPictureApiEnum.java, v 0.1 2022-02-10 上午9:51 youmingming
 */
public enum UmPictureApiEnum {
    AGGREGATION_FILES_UPLOAD_DIRECT("图片批量上传", "aggregation.files.upload.direct");

    private String name;
    private String value;

    UmPictureApiEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static UmPictureApiEnum getByValue(String value) {
        UmPictureApiEnum[] valueList = UmPictureApiEnum.values();
        for (UmPictureApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }
}