/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.swift.response.trade.pay;

import com.fshows.swift.response.base.SwiftBizResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import javax.validation.constraints.NotNull;

import java.io.Serializable;

/**
 *
 *
 * @author
 * @version SwiftTradeNativeResponse.java, v 0.1 2023-10-18 17:31:34
 */
@Data
public class SwiftTradeNativeResponse  extends SwiftBizResponse implements Serializable {

    private static final long serialVersionUID = -2213838555531658258L;


    /**
     * 门店号，由平台分配
     * (必填)
     */
    private String mchId;

    /**
     * 终端设备号
     * (选填)
     */
    private String deviceInfo;

    /**
     * 商户可用此参数自定义去生成二维码后展示出来进行扫码支付
     * (必填)
     */
    private String codeUrl;

    /**
     * 此参数的值即是根据code_url生成的可以扫码支付的二维码图片地址
     * (必填)
     */
    private String codeImgUrl;

    /**
     * 唯一识别号
     * (选填)
     */
    private String uuid;

}