/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.swift.response.trade.order;

import com.fshows.swift.response.base.SwiftBizResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import javax.validation.constraints.NotNull;

import java.io.Serializable;

/**
 * 退款查询response
 *
 * @author
 * @version SwiftRefundQueryResponse.java, v 0.1 2023-10-18 18:09:05
 */
@Data
public class SwiftRefundQueryResponse  extends SwiftBizResponse implements Serializable {

    private static final long serialVersionUID = -2213838555501558362L;


    /**
     * 支付宝：pay.alipay.jspay 微信：pay.wechat.jspa
     * (选填)
     */
    private String tradeType;

    /**
     * 门店编号，由平台分配
     * (必填)
     */
    private String mchId;

    /**
     * 平台支付分配的终端设备号
     * (选填)
     */
    private String deviceInfo;

    /**
     * 平台交易号。
     * (必填)
     */
    private String transactionId;

    /**
     * 商户系统内部的订单号
     * (必填)
     */
    private String outTradeNo;

    /**
     * 第三方平台交易号
     * (选填)
     */
    private String outTransactionId;

    /**
     * 退款记录数
     * (必填)
     */
    private Integer refundCount;

    /**
     * 商户退款单号
     * (必填)
     */
    private String outRefundNo;

    /**
     * 平台退款单号
     * (必填)
     */
    private String refundId;

    /**
     * 平台退款单号
     * (选填)
     */
    private String outRefundId;

    /**
     * ORIGINAL—原路退款，默认
     * (必填)
     */
    private String refundChannel;

    /**
     * 退款总金额,单位为分,可以做部分退款
     * (必填)
     */
    private Integer refundFee;

    /**
     * 现金券退款金额 <= 退款金额， 退款金额-现金券退款金额为现金
     * (选填)
     */
    private Integer couponRefundFee;

    /**
     * yyyyMMddHHmmss
     * (选填)
     */
    private String refundTime;

    /**
     * SUCCESS—退款成功 FAIL—退款失败 PROCESSING—退款处理中 NOTSURE—未确定， 需要商户原退款单号重新发起 CHANGE—转入代发，退款到银行发现用户的卡作废或者冻结了，导致原路退款银行卡失败，资金回流到商户的现金帐号，需要商户人工干预，通过线下或者平台转账的方式进行退款。
     * (必填)
     */
    private String refundStatus;

    /**
     * 退款状态信息
     * (选填)
     */
    private String refundStatusInfo;

    /**
     * 分账退款明细，详见“分账退款明细说明”
     * (选填)
     */
    private String refundProfitShareInfos;

}