/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.swift.request.trade.order;

import com.fshows.swift.request.base.SwiftBizRequest;
import com.fshows.swift.response.trade.order.SwiftOrderCloseResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import javax.validation.constraints.NotNull;
import com.fshows.swift.enums.api.SwiftApiDefinitionEnum;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 订单关闭request
 *
 * @author
 * @version SwiftOrderCloseRequest.java, v 0.1 2023-10-18 18:10:28
 */
@Data
public class SwiftOrderCloseRequest extends SwiftBizRequest<SwiftOrderCloseResponse, SwiftApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555177321419L;


    /**
     * 门店编号
     *
     * 门店编号，由平台分配
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "mchId长度不能超过32")
    private String mchId;

    /**
     * 商户订单号
     *
     * 商户系统内部的订单号 ,32个字符内、 可包含字母,确保在商户系统唯一
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "outTradeNo长度不能超过32")
    private String outTradeNo;

}