/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.swift.request.cib.trade;

import com.fshows.swift.enums.api.CibApiDefinitionEnum;
import com.fshows.swift.enums.api.SwiftApiDefinitionEnum;
import com.fshows.swift.request.base.SwiftBizRequest;
import com.fshows.swift.response.cib.trade.pay.CibScanCardPayResponse;
import com.fshows.swift.response.trade.pay.SwiftScanCardPayResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 付款码支付request
 *
 * @author
 * @version SwiftScanCardPayRequest.java, v 0.1 2023-10-18 18:16:13
 */
@Data
public class CibScanCardPayRequest extends SwiftBizRequest<CibScanCardPayResponse, CibApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -7492994878279349376L;

    /**
     * 门店编号
     *
     * 门店编号，由平台分配
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "mchId长度不能超过32")
    private String mchId;

    /**
     * 商户订单号
     *
     * 商户系统内部的订单号 ,5到32个字符、 只能包含字母数字或者下划线，区分大小写，每次下单请求确保在商户系统唯一
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "outTradeNo长度不能超过32")
    private String outTradeNo;

    /**
     * 设备号
     *
     * 终端设备号，商户自定义。特别说明：对于QQ钱包支付，此参数必传，否则会报错。
     * (选填)
     */
    @Length(max = 32, message = "deviceInfo长度不能超过32")
    private String deviceInfo;

    /**
     * 商品描述
     *
     * 商品描述
     * (必填)
     */
    @NotBlank
    @Length(max = 128, message = "body长度不能超过128")
    private String body;

    /**
     * 单品信息
     *
     * 单品优惠活动该字段必传，且必须按照规范上传，JSON格式，详见【单品优惠活动字段说明】
     * (选填)
     */
    @Length(max = 1024, message = "goodsDetail长度不能超过1024")
    private String goodsDetail;

    /**
     * 分账信息
     *
     * 必须按照规范上传，JSON格式，详见【分账字段说明】
     * (选填)
     */
    @Length(max = 512, message = "profitShareInfos长度不能超过512")
    private String profitShareInfos;

    /**
     * 花呗分期数
     *
     * 只支持传"3"|"6"|"12"，只适用于支付宝支付
     * (选填)
     */
    private String hbFqNum;

    /**
     * 承担手续费角色【支付宝】
     *
     * 只支持传"0"|"100"，商家承担手续费传"100"，用户承担传"0"，在有hb_fq_num字段时默认为“0”
     * (选填)
     */
    private String hbFqSellerPercent;

    /**
     * 公众账号ID 【微信】
     *
     * 微信公众平台基本配置中的AppID(应用ID)，传入后支付成功可返回对应公众号下的用户openid
     * (选填)
     */
    @Length(max = 32, message = "subAppid长度不能超过32")
    private String subAppid;

    /**
     * 附加信息
     *
     * 商户附加信息，可做扩展参数
     * (选填)
     */
    @Length(max = 127, message = "attach长度不能超过127")
    private String attach;

    /**
     * 电子发票【微信】
     *
     * 需要和微信公众平台的发票功能联合，传入true时，微信支付成功消息和支付详情页将出现开票入口[新增need_receipt【适用于微信】]
     * (选填)
     */
    private Boolean needReceipt;

    /**
     * 总金额
     *
     * 总金额，以分为单位，不允许包含任何字、符号
     * (必填)
     */
    @NotNull
    private Integer totalFee;

    /**
     * 终端IP
     *
     * 上传商户真实的发起交易的终端出网IP
     * (必填)
     */
    @NotBlank
    private String mchCreateIp;

    /**
     * 授权码
     *
     * 扫码支付授权码， 设备读取用户展示的条码或者二维码信息
     * (必填)
     */
    @NotBlank
    @Length(max = 128, message = "authCode长度不能超过128")
    private String authCode;

    /**
     * 订单生成时间
     *
     * 订单生成时间，格式为yyyyMMddHHmmss，如2009年12月25日9点10分10秒表示为20091225091010。时区为GMT+8 beijing。该时间取自商户服务器。注：订单生成时间与超时时间需要同时传入才会生效。
     * (选填)
     */
    @Length(max = 14, message = "timeStart长度不能超过14")
    private String timeStart;

    /**
     * 订单超时时间
     *
     * 订单失效时间，格式为yyyyMMddHHmmss，如2009年12月27日9点10分10秒表示为20091227091010。时区为GMT+8 beijing。该时间取自商户服务器。注：订单生成时间与超时时间需要同时传入才会生效。
     * (选填)
     */
    @Length(max = 14, message = "timeExpire长度不能超过14")
    private String timeExpire;

    /**
     * 操作员
     *
     * 操作员帐号,默认为门店编号
     * (选填)
     */
    @Length(max = 32, message = "opUserId长度不能超过32")
    private String opUserId;

    /**
     * 设备编号
     *
     * 
     * (选填)
     */
    @Length(max = 32, message = "opDeviceId长度不能超过32")
    private String opDeviceId;

    /**
     * 商品标记
     *
     * 商品标记
     * (选填)
     */
    @Length(max = 32, message = "goodsTag长度不能超过32")
    private String goodsTag;

}