/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.swift.request.cib.trade;

import com.fshows.swift.enums.api.CibApiDefinitionEnum;
import com.fshows.swift.request.base.SwiftBizRequest;
import com.fshows.swift.response.cib.trade.pay.CibAlipayPreOrderCreateResponse;
import com.fshows.swift.response.cib.trade.pay.CibWxPreOrderCreateResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 支付宝统一下单
 *
 * @author wangyi
 * @version CibAlipayPreOrderCreateRequest.java, v 0.1 2024-09-12 17:08 wangyi
 */
@Data
public class CibAlipayPreOrderCreateRequest extends SwiftBizRequest<CibAlipayPreOrderCreateResponse, CibApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -5305817249126440366L;

    /**
     * 商户号
     *
     * 商户号，由平台分配
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchId长度不能超过15")
    private String mchId;

    /**
     * 商户订单号
     *
     * 商户系统内部的订单号 ,32个字符内、 可包含字母,确保在商户系统唯一
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "outTradeNo长度不能超过32")
    private String outTradeNo;

    /**
     * 总金额
     *
     * 总金额，以分为单位，不允许包含任何字、符号
     * (必填)
     */
    @NotNull
    private Integer totalFee;

    /**
     * 商品描述
     *
     * 商品描述
     * (必填)
     */
    @NotBlank
    @Length(max = 128, message = "body长度不能超过128")
    private String body;

    /**
     * 买家支付宝账号，和buyer_id不能同时为空
     */
    @Length(max = 100, message = "buyerLogonId长度不能超过100")
    private String buyerLogonId;

    /**
     * 买家支付宝用户ID，和buyer_logon_id不能同时为空
     */
    @Length(max = 100, message = "buyerId长度不能超过100")
    private String buyerId;

    /**
     * 终端IP
     *
     * 上传商户真实的发起交易的终端出网IP
     * (必填)
     */
    @NotBlank
    private String mchCreateIp;

    /**
     * 通知地址
     *
     * 接收平台异步回调通知的地址，必须为外网可访问的url，确保平台能通过互联网访问该地址，若无需接收通知，请固定传值为127.0.0.1
     * (必填)
     */
    @NotBlank
    @Length(max = 255, message = "notifyUrl长度不能超过255")
    private String notifyUrl;

    /**
     * 订单生成时间
     *
     * 订单生成时间，格式为yyyyMMddHHmmss，如2009年12月25日9点10分10秒表示为20091225091010。时区为GMT+8 beijing。该时间取自商户服务器。注：订单生成时间与超时时间需要同时传入才会生效。
     * (选填)
     */
    @Length(max = 14, message = "timeStart长度不能超过14")
    private String timeStart;

    /**
     * 订单超时时间
     *
     * 订单失效时间，格式为yyyyMMddHHmmss，如2009年12月27日9点10分10秒表示为20091227091010。时区为GMT+8 beijing。该时间取自商户服务器。注：订单生成时间与超时时间需要同时传入才会生效。
     * (选填)
     */
    @Length(max = 14, message = "timeExpire长度不能超过14")
    private String timeExpire;

    /**
     * 订单最晚付款时间
     *
     * 该笔订单允许的最晚付款时间，逾期将关闭交易，从下单开始计时。取值范围：1m~15d。m-分钟，h-小时，d-天，1c-当天(1c-当天的情况下，无论交易何时创建，都在0点关闭)。该参数数值不接受小数点，如1.5h，可转换为90m。
     * (选填)
     */
    private String qrCodeTimeoutExpress;

    /**
     * 设备号
     *
     * 终端设备号
     * (选填)
     */
    @Length(max = 32, message = "deviceInfo长度不能超过32")
    private String deviceInfo;

    /**
     * 操作员
     *
     * 操作员帐号,默认为门店编号
     * (选填)
     */
    @Length(max = 32, message = "opUserId长度不能超过32")
    private String opUserId;

    /**
     * 单品信息
     * 单品优惠活动该字段必传，且必须按照规范上传，JSON格式，详见【优惠活动字段说明】
     */
    private String goodsDetail;

    /**
     * 商品标记
     *
     * 商品标记，微信平台配置的商品标记，用于优惠券或者满减使用
     * (选填)
     */
    @Length(max = 32, message = "goodsTag长度不能超过32")
    private String goodsTag;

    /**
     * 电子发票
     *
     * 需要和微信公众平台的发票功能联合，传入true时，微信支付成功消息和支付详情页将出现开票入口[新增need_receipt【适用于微信】]
     * (选填)
     */
    private Boolean needReceipt;

    /**
     * 附加信息
     *
     * 商户附加信息，可做扩展参数
     * (选填)
     */
    @Length(max = 127, message = "attach长度不能超过127")
    private String attach;

    /**
     * 限制信用卡
     * 限定用户使用时能否使用信用卡，值为1，禁用信用卡，值为0或者不传此参数则不禁用
     * (选填)
     */
    @Length(max = 1, message = "limitCreditPay长度不能超过1")
    private String limitCreditPay;

    /**
     * 花呗分期数
     *
     * 只支持传"3"|"6"|"12"，只适用于支付宝支付
     * (选填)
     */
    private String hbFqNum;

    /**
     * 承担手续费角色【支付宝】
     *
     * 只支持传"0"|"100"，商家承担手续费传"100"，用户承担传"0"，在有hb_fq_num字段时默认为“0 ”
     * (选填)
     */
    private String hbFqSellerPercent;
}