/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.swift.request.cib.order;

import com.fshows.swift.enums.api.CibApiDefinitionEnum;
import com.fshows.swift.enums.api.SwiftApiDefinitionEnum;
import com.fshows.swift.request.base.SwiftBizRequest;
import com.fshows.swift.response.cib.trade.order.CibRefundQueryResponse;
import com.fshows.swift.response.trade.order.SwiftRefundQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 退款查询request
 *
 * @author
 * @version SwiftRefundQueryRequest.java, v 0.1 2023-10-18 18:09:05
 */
@Data
public class CibRefundQueryRequest extends SwiftBizRequest<CibRefundQueryResponse, CibApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = 1676411372837173460L;

    /**
     * 门店编号
     *
     * 门店编号，由平台分配
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "mchId长度不能超过32")
    private String mchId;

    /**
     * 商户订单号
     *
     * 商户系统内部的订单号, out_trade_no和transaction_id至少一个必填，同时存在时transaction_id优先
     * (选填)
     */
    @Length(max = 32, message = "outTradeNo长度不能超过32")
    private String outTradeNo;

    /**
     * 平台订单号
     *
     * 可传入平台订单号或第三方商户单号（third_order_no）, out_trade_no和transaction_id至少一个必填，同时存在时transaction_id优先
     * (选填)
     */
    @Length(max = 32, message = "transactionId长度不能超过32")
    private String transactionId;

    /**
     * 商户退款单号
     *
     * 商户退款单号，32个字符内、可包含字母,确保在商户系统唯一。
     * (选填)
     */
    @Length(max = 32, message = "outRefundNo长度不能超过32")
    private String outRefundNo;

    /**
     * 平台退款单号
     *
     * 平台退款单号refund_id、out_refund_no、out_trade_no 、transaction_id 四个参数必填一个， 如果同时存在优先级为：refund_id>out_refund_no>transaction_id>out_trade_no
     * (选填)
     */
    @Length(max = 32, message = "refundId长度不能超过32")
    private String refundId;

}