/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.swift.request.cib.bill;

import com.fshows.swift.enums.api.CibApiDefinitionEnum;
import com.fshows.swift.request.base.SwiftBizRequest;
import com.fshows.swift.response.base.SwiftBizResponse;
import com.fshows.swift.response.cib.trade.order.CibOrderQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author wangqilei
 * @version CibDownloadRequest.java, v 0.1 2024-12-02 4:41 PM wangqilei
 */
@Data
public class CibBillDownloadRequest extends SwiftBizRequest<SwiftBizResponse, CibApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -6371550037690744515L;

    /**
     * 门店编号
     *
     * 门店编号，由平台分配
     *
     * 接口类型参数值：（与传入的mch_id的类型对应）
     * pay.bill.merchant：下载单个商户时的对账单
     * pay.bill.bigMerchant：下载连锁商户下所有门店的对账单
     * pay.bill.agent：下载某内部机构/外包服务机构下所有商户的对账单
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "mchId长度不能超过32")
    private String mchId;

    /**
     * 账单日期
     *
     * 格式：yyyyMMdd(如：20150101)
     * (必填)
     */
    @NotBlank
    @Length(max = 8, message = "billDate长度不能超过8")
    private String billDate;

    /**
     * 账单类型
     *
     * ALL：返回支付成功和转入退款的订单，默认值
     * SUCCESS：返回支付成功的订单
     *
     * REFUND：返回转入退款的订单
     * (必填)
     */
    @NotBlank
    @Length(max = 8, message = "billType长度不能超过8")
    private String billType;
}