package com.fshows.swift.enums.trade;

import org.apache.commons.lang3.StringUtils;

/**
 * 威富通交易API响应码枚举
 *
 * @author liluqing
 * @version SwiftTradeResponseCodeEnum.java, v 0.1 2022-03-02 11:04 liluqing
 */
public enum SwiftTradeResponseCodeEnum {
    SUCCESS("成功", "BBS00000"),
    PAYING("交易状态为支付中", "BBS10000")
    ;

    private String name;
    private String value;

    SwiftTradeResponseCodeEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    public static SwiftTradeResponseCodeEnum getByValue(String value) {
        SwiftTradeResponseCodeEnum[] valueList = SwiftTradeResponseCodeEnum.values();
        for (SwiftTradeResponseCodeEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }
}