/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.swift.client.impl.signer;


import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.MD5;
import com.fshows.swift.client.base.ApiClientConfig;
import com.fshows.swift.client.base.ISigner;
import com.fshows.swift.client.base.SignParam;
import com.fshows.swift.client.base.VerifySignParam;
import com.fshows.swift.exception.SwiftApiException;
import com.fshows.swift.request.base.SwiftBizRequest;
import com.fshows.swift.util.RequestParamUtils;
import com.fshows.swift.util.LogUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;
import java.util.TreeMap;

/**
 * 加签默认实现
 *
 * @author liluqing
 * @version DefaultSignerImpl.java, v 0.1 2022-03-02 18:32
 */
@Slf4j
public class DefaultSignerImpl implements ISigner {
    /**
     * 获取待加签字符串，格式：addn_inf=&curr_type=&goods_des=卡盟测试&goods_detail=asasda&goods_tag=&ins_cd=08A9999999&
     *
     * @return
     */
    public static String getWaitSignStr(Map<String, String> dataMap, ApiClientConfig apiClientConfig) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : dataMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.equals(key, "sign")
                    || StringUtils.startsWith(key, "reserved")) {
                continue;
            }
            if (StrUtil.isBlank(value)) {
                continue;
            }
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(key).append("=").append(value);
        }
        sb.append("&key=").append(apiClientConfig.getPayCompanyPublicKey());
        return sb.toString();
    }

    public static void main(String[] args) {
        ApiClientConfig apiClientConfig = new ApiClientConfig();
        apiClientConfig.setPayCompanyPublicKey("040f23510fbf4b34ae3895272e83c58c");
        String privateKey = "040f23510fbf4b34ae3895272e83c58c";

        Map<String, String> map = new TreeMap<>();
        map.put("name", "111111");
        map.put("age", "222222");
        String waitSignStr = getWaitSignStr(map, apiClientConfig);
        System.out.println(waitSignStr + "\n\n\n");
        // 创建加签对象
        String digestHex = MD5.create().digestHex(waitSignStr);
        System.out.println(digestHex);
        map.put("sign", digestHex);
        System.out.println("\n\n\n" + RequestParamUtils.generateXml(map));
    }

    @Override
    public String sign(SignParam signParam, ApiClientConfig apiClientConfig) throws SwiftApiException {
        return doSign(signParam, apiClientConfig);
    }

    @Override
    public Boolean verifySign(Map<String, String> resMap, VerifySignParam verifySignParam, ApiClientConfig apiClientConfig) throws SwiftApiException {
        try {
            // 响应签名
            String resSign = resMap.get("sign");
            // 获取待加签字符串
            String waitSignStr = getWaitSignStr(resMap, apiClientConfig);
            //加签
            String md5Hex = DigestUtils.md5Hex(waitSignStr.getBytes(apiClientConfig.getCharset())).toLowerCase();
            //加签
            return resSign.equalsIgnoreCase(md5Hex);
        } catch (Exception e) {
            LogUtil.error(log, "【swiftpass-sdk】响应结果验签失败 >> signParam={}", e, verifySignParam);
            throw new SwiftApiException("swiftpass响应结果验签失败", e);
        }
    }

    /**
     * 执行方法加签
     *
     * @param signParam
     * @param apiClientConfig
     * @return
     * @throws SwiftApiException
     */
    public String doSign(SignParam signParam, ApiClientConfig apiClientConfig) throws SwiftApiException {
        try {
            SwiftBizRequest request = signParam.getRequest();
            // 获取待加签字符串
            Map<String, String> data = RequestParamUtils.toMap(request, apiClientConfig.isHump());
            // 获取待加签字符串
            String waitSignStr = getWaitSignStr(data, apiClientConfig);
            LogUtil.info(log, "【swiftpass-sdk】待加签字符串 >> waitSignStr={}", waitSignStr);
            //加签
            String md5Hex = DigestUtils.md5Hex(waitSignStr.getBytes(apiClientConfig.getCharset()));
            return md5Hex.toLowerCase();
        } catch (Exception e) {
            LogUtil.error(log, "【swiftpass-sdk】请求加签失败 >> signParam={}", e, signParam);
            throw new SwiftApiException("swiftpass请求加签失败", e);
        }
    }
}