/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.swift.client.base;

import com.fshows.swift.request.base.SwiftBizRequest;
import com.fshows.swift.response.base.SwiftBizResponse;

/**
 * 威富通API资源定义
 * <p>
 * 目前API资源采用enum方式定义
 *
 * @author liluqing
 * @version ISwiftApiDefinition.java, v 0.1 2022-03-01 20:24
 */
public interface ISwiftApiDefinition {

    /**
     * 获取url资源子路径
     * 例如: 接口的URL是 “https://s2.lakala.com/api/v3/labs/trans/preorder”
     * ,则ApiSubPath则是域名后的部分内容“/api/v3/labs/trans/preorder”
     */
    String getApiSubURI();

    /**
     * 获取api版本
     *
     * @return
     */
    String getVersion();

    /**
     * 获取requestClass
     *
     * @return
     */
    <T extends SwiftBizRequest>  Class<T> getRequestClass();

    /**
     * 获取responseClass
     *
     * @return
     */
    <T extends SwiftBizResponse> Class<T> getResponseClass();
}