/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.swift.client.base;

import com.fshows.swift.exception.SwiftApiException;
import com.fshows.swift.request.base.SwiftBizRequest;
import com.fshows.swift.response.base.SwiftBizResponse;

/**
 * 威富通API客户端
 *
 * @author liluqing
 * @version ISwiftApiClient.java, v 0.1 2022-03-02 11:17
 */
public interface ISwiftApiClient {

    /**
     * 调用威富通交易相关接口
     *
     * @param request
     * @param <T>
     * @return
     */
    <T extends SwiftBizResponse, R extends ISwiftApiDefinition> T execute(SwiftBizRequest<T,R> request, R tradeApiDefinitionEnum) throws SwiftApiException;

    /**
     * 调用威富通交易相关接口(自定义二代编号)
     *
     * @param request
     * @param <T>
     * @return
     */
    <T extends SwiftBizResponse, R extends ISwiftApiDefinition> T execute(SwiftBizRequest<T,R> request, R tradeApiDefinitionEnum, String subAgentId) throws SwiftApiException;
}