/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.swift.response.trade.order;

import com.fshows.swift.response.base.SwiftBizResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import javax.validation.constraints.NotNull;

import java.io.Serializable;

/**
 *
 *
 * @author
 * @version SwiftOrderQueryResponse.java, v 0.1 2023-10-18 17:34:25
 */
@Data
public class SwiftOrderQueryResponse  extends SwiftBizResponse implements Serializable {

    private static final long serialVersionUID = -2213838555699009449L;


    /**
     * 门店编号，由平台分配
     * (必填)
     */
    private String mchId;

    /**
     * 平台支付分配的终端设备号
     * (选填)
     */
    private String deviceInfo;

    /**
     * SUCCESS—支付成功 REFUND—转入退款 NOTPAY—未支付 CLOSED—已关闭 REVERSE—已冲正 REVOK—已撤销 PAYERROR-支付失败（其他原因，如银行返回失败）
     * (必填)
     */
    private String tradeState;

    /**
     * 对当前查询订单状态的描述
     * (选填)
     */
    private String tradeStateDesc;

    /**
     * 支付宝：pay.alipay.jspay 微信：pay.wechat.jspay
     * (必填)
     */
    private String tradeType;

    /**
     * 用户在商户 appid 下的唯一标识
     * (必填)
     */
    private String openid;

    /**
     * 用户是否关注公众账号，Y-关注，N-未关注，仅在公众账号类型支付有效
     * (必填)
     */
    private String isSubscribe;

    /**
     * 平台交易号
     * (必填)
     */
    private String transactionId;

    /**
     * 第三方订单号（支付成功后会返回，没支付则不会），如微信交易订单号
     * (选填)
     */
    private String outTransactionId;

    /**
     * 第三方商户单号（支付成功后会返回，没支付则不会
     * (选填)
     */
    private String thirdOrderNo;

    /**
     * 商户系统内部的定单号，32个字符内、可包含字母
     * (必填)
     */
    private String outTradeNo;

    /**
     * 总金额，以分为单位，不允许包含任何字、符号
     * (必填)
     */
    private Integer totalFee;

    /**
     * 现金券支付金额<=订单总金额， 订单总金额-现金券金额为现金支付金额
     * (选填)
     */
    private Integer couponFee;

    /**
     * 优惠详情，内容详见【单品优惠活动字段说明】
     * (选填)
     */
    private String promotionDetail;

    /**
     * 货币类型，符合 ISO 4217 标准的三位字母代码，默认人民币：CNY
     * (选填)
     */
    private String feeType;

    /**
     * 商家数据包，原样返回
     * (选填)
     */
    private String attach;

    /**
     * 银行类型
     * (必填)
     */
    private String bankType;

    /**
     * 银行订单号，若为微信支付则为空
     * (选填)
     */
    private String bankBillno;

    /**
     * 支付完成时间，格式为yyyyMMddHHmmss，如2009年12月27日9点10分10秒表示为20091227091010。时区为GMT+8 beijing。该时间取自平台服务器
     * (必填)
     */
    private String timeEnd;

    /**
     * 付款时间，格式为yyyyMMddHHmmss，如2009年12月27日9点10分10秒表示为20091227091010。时区为GMT+8 beijing。该时间取自平台服务器
     * (选填)
     */
    private String gmtPayment;

    /**
     * 免充值优惠金额
     * (选填)
     */
    private Integer mdiscount;

}