/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.swift.response.trade.item;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 *
 * @author liluqing
 * @version AlipayFundBillListItem.java, v 0.1 2023-10-19 9:45
 */
@Data
public class AlipayFundBillListItem implements Serializable {

    private static final long serialVersionUID = -1945317124595695333L;

    /**
     * 交易使用的资金渠道，详见 支付渠道列表
     * (必填)
     */
    private String fundChannel;

    /**
     * 该支付工具类型所使用的金额
     * (必填)
     */
    private BigDecimal amount;

    /**
     * 渠道实际付款金额
     * (选填)
     */
    private BigDecimal realAmount;
}