/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.swift.request.base;

import com.fshows.swift.client.base.ISwiftApiDefinition;
import com.fshows.swift.response.base.SwiftBizResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 业务请求参数的基础父类
 *
 * @author liluqing
 * @version SwiftBizRequest.java, v 0.1 2022-03-01 20:19
 */
@Data
public class SwiftBizRequest<T extends SwiftBizResponse, E extends ISwiftApiDefinition> implements Serializable {

    private static final long serialVersionUID = 3579701521402004039L;


    @Length(max = 32, message = "service长度不能超过32")
    private String service;


    private String version;

    /**
     * 字符集
     *
     * 可选值 UTF-8 ，默认为 UTF-8
     * (选填)
     */
    @Length(max = 8, message = "charset长度不能超过8")
    private String charset;


    /**
     * 签名
     *
     * MD5/RSA_1_256/RSA_1_1签名结果，详见“安全规范”
     * (必填)
     */
    private String sign;


    /**
     * 签名方式
     *
     * 签名类型，取值：MD5、RSA_1_256、RSA_1_1，默认：MD5
     * (必填)
     */
    @Length(max = 12, message = "signType长度不能超过12")
    private String signType;

    /**
     * 渠道编号
     *
     * 由平台分配。传入了此参数时，数据的签名使用的将是服务商的signKey
     * (选填)
     */
    @Length(max = 32, message = "signAgentno长度不能超过32")
    private String signAgentno;

    /**
     * 随机字符串
     *
     * 随机字符串，不长于 32 位
     * (必填)
     */
    @Length(max = 32, message = "nonceStr长度不能超过32")
    private String nonceStr;


}