package com.fshows.swift.enums.api;

import com.fshows.swift.client.base.ISwiftApiDefinition;
import com.fshows.swift.constant.SwiftConstant;
import com.fshows.swift.request.cib.order.CibOrderQueryRequest;
import com.fshows.swift.request.cib.order.CibOrderRefundRequest;
import com.fshows.swift.request.cib.order.CibRefundQueryRequest;
import com.fshows.swift.request.cib.trade.CibAlipayPreOrderCreateRequest;
import com.fshows.swift.request.cib.trade.CibScanCardPayRequest;
import com.fshows.swift.request.cib.trade.CibWxPreOrderCreateRequest;
import com.fshows.swift.request.trade.order.SwiftOrderQueryRequest;
import com.fshows.swift.request.trade.order.SwiftOrderRefundRequest;
import com.fshows.swift.request.trade.order.SwiftRefundQueryRequest;
import com.fshows.swift.request.trade.pay.SwiftScanCardPayRequest;
import com.fshows.swift.response.cib.trade.order.CibOrderQueryResponse;
import com.fshows.swift.response.cib.trade.order.CibOrderRefundResponse;
import com.fshows.swift.response.cib.trade.order.CibRefundQueryResponse;
import com.fshows.swift.response.cib.trade.pay.CibAlipayPreOrderCreateResponse;
import com.fshows.swift.response.cib.trade.pay.CibScanCardPayResponse;
import com.fshows.swift.response.cib.trade.pay.CibWxPreOrderCreateResponse;
import com.fshows.swift.response.trade.order.SwiftOrderQueryResponse;
import com.fshows.swift.response.trade.order.SwiftOrderRefundResponse;
import com.fshows.swift.response.trade.order.SwiftRefundQueryResponse;
import com.fshows.swift.response.trade.pay.SwiftScanCardPayResponse;

/**
 * 兴业银行交易相关API
 *
 * @author liluqing
 * @version CibApiDefinitionEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum CibApiDefinitionEnum implements ISwiftApiDefinition {
    WX_PRE_ORDER_CREATE(
            "微信统一下单",
            "pay.weixin.jspay",
            SwiftConstant.TRADE_API_VERSION_V2,
            CibWxPreOrderCreateRequest.class,
            CibWxPreOrderCreateResponse.class
    ),
    ALIPAY_PRE_ORDER_CREATE(
            "支付宝统一下单",
            "pay.alipay.jspay",
            SwiftConstant.TRADE_API_VERSION_V2,
            CibAlipayPreOrderCreateRequest.class,
            CibAlipayPreOrderCreateResponse.class
    ),
    SCAN_CARD_CREATE(
            "被扫交易（付款码支付）",
            "unified.trade.micropay",
            SwiftConstant.TRADE_API_VERSION_V2,
            CibScanCardPayRequest.class,
            CibScanCardPayResponse.class
    ),
    REFUND_CREATE(
            "退款申请发起",
            "unified.trade.refund",
            SwiftConstant.TRADE_API_VERSION_V2,
            CibOrderRefundRequest.class,
            CibOrderRefundResponse.class
    ),
    REFUND_QUERY(
            "退款查询接口",
            "unified.trade.refundquery",
            SwiftConstant.TRADE_API_VERSION_V2,
            CibRefundQueryRequest.class,
            CibRefundQueryResponse.class
    ),
    ORDER_QUERY(
            "订单查询接口",
            "unified.trade.query",
            SwiftConstant.TRADE_API_VERSION_V2,
            CibOrderQueryRequest.class,
            CibOrderQueryResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本号
     */
    private String version;
    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;


    CibApiDefinitionEnum(String name,
                         String apiSubURI,
                         String version,
                         Class requestClass,
                         Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiSubURI() {
        return apiSubURI;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}