/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.swift.response.cib.trade.order;

import com.fshows.swift.response.base.SwiftBizResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * 订单退款申请response
 *
 * @author
 * @version SwiftOrderRefundResponse.java, v 0.1 2023-10-18 18:03:41
 */
@Data
public class CibOrderRefundResponse extends SwiftBizResponse implements Serializable {

    private static final long serialVersionUID = 2211990250848836895L;

    /**
     * 门店编号，由平台分配
     * (必填)
     */
    private String mchId;

    /**
     * 平台支付分配的终端设备号
     * (选填)
     */
    private String deviceInfo;

    /**
     * 平台交易号
     * (必填)
     */
    private String transactionId;

    /**
     * 商户系统内部的订单号
     * (必填)
     */
    private String outTradeNo;

    /**
     * 第三方平台交易号
     * (选填)
     */
    private String outTransactionId;

    /**
     * 商户退款单号
     * (必填)
     */
    private String outRefundNo;

    /**
     * 平台退款单号
     * (必填)
     */
    private String refundId;

    /**
     * 支付宝：pay.alipay.jspay 微信：pay.wechat.jspay
     * (选填)
     */
    private String tradeType;

    /**
     * ORIGINAL—原路退款，默认
     * (必填)
     */
    private String refundChannel;

    /**
     * 退款总金额,单位为分,可以做部分退款
     * (必填)
     */
    private Integer refundFee;

}