/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.swift.client.impl.signer;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.Sign;
import com.fshows.swift.client.base.ApiClientConfig;
import com.fshows.swift.client.base.ISigner;
import com.fshows.swift.client.base.SignParam;
import com.fshows.swift.client.base.VerifySignParam;
import com.fshows.swift.exception.SwiftApiException;
import com.fshows.swift.request.base.SwiftBizRequest;
import com.fshows.swift.util.LogUtil;
import com.fshows.swift.util.RequestParamUtils;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RsaSignHandlerImpl
implements ISigner {
    private static final Logger log = LoggerFactory.getLogger(RsaSignHandlerImpl.class);

    public static String getWaitSignStr(Map<String, String> dataMap, ApiClientConfig apiClientConfig) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : dataMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.equals((CharSequence)key, (CharSequence)"sign") || StringUtils.startsWith((CharSequence)key, (CharSequence)"reserved") || StrUtil.isBlank((CharSequence)value)) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(key).append("=").append(value);
        }
        return sb.toString();
    }

    @Override
    public String sign(SignParam signParam, ApiClientConfig apiClientConfig) throws SwiftApiException {
        String waitSignStr = null;
        try {
            SwiftBizRequest request = signParam.getRequest();
            Map<String, String> data = RequestParamUtils.toMap(request, apiClientConfig.isHump());
            String privateKey = apiClientConfig.getFubeiPrivateKey();
            waitSignStr = RsaSignHandlerImpl.getWaitSignStr(data, apiClientConfig);
            Sign sign = new Sign(apiClientConfig.getSignTypeEnum().getAlgorithm(), SecureUtil.decode((String)privateKey), null);
            byte[] signed = sign.sign(waitSignStr.getBytes(apiClientConfig.getCharset()));
            return Base64.encode((byte[])signed);
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010swiftpass-sdk\u3011\u8bf7\u6c42\u52a0\u7b7e\u5931\u8d25 >> apiClientConfig={}, waitSignStr={}", e, apiClientConfig, waitSignStr);
            throw new SwiftApiException("swiftpass\u8bf7\u6c42\u52a0\u7b7e\u5931\u8d25", e);
        }
    }

    @Override
    public Boolean verifySign(Map<String, String> resMap, VerifySignParam verifySignParam, ApiClientConfig apiClientConfig) throws SwiftApiException {
        return true;
    }
}

