/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.swift.client.impl;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.RandomUtil;
import com.fshows.swift.client.base.ApiClientConfig;
import com.fshows.swift.client.base.IHttpRequest;
import com.fshows.swift.client.base.ISigner;
import com.fshows.swift.client.base.ISwiftApiDefinition;
import com.fshows.swift.client.base.SignParam;
import com.fshows.swift.client.impl.AbstractSwiftApiClientImpl;
import com.fshows.swift.client.impl.signer.RsaSignHandlerImpl;
import com.fshows.swift.enums.api.SwiftApiDefinitionEnum;
import com.fshows.swift.exception.SwiftApiException;
import com.fshows.swift.request.base.SwiftBizRequest;
import com.fshows.swift.response.base.SwiftBizResponse;
import com.fshows.swift.util.LogUtil;
import com.fshows.swift.util.RequestParamUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CibApiClientImpl
extends AbstractSwiftApiClientImpl {
    private static final Logger log = LoggerFactory.getLogger(CibApiClientImpl.class);
    private static final List<String> REFUND_QUERY_FIELD_LIST = Arrays.asList("out_refund_no", "refund_id", "out_refund_id", "refund_channel", "refund_fee", "out_refund_id", "coupon_refund_fee", "refund_time", "refund_status", "refund_status_info");

    public CibApiClientImpl(ApiClientConfig apiClientConfig) throws SwiftApiException {
        super(apiClientConfig);
        this.signer = new RsaSignHandlerImpl();
    }

    public CibApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws SwiftApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    @Override
    public <T extends SwiftBizResponse, R extends ISwiftApiDefinition> T execute(SwiftBizRequest<T, R> request, R cibApiDefinitionEnum) throws SwiftApiException {
        return (T)super.doExecute(request, cibApiDefinitionEnum);
    }

    @Override
    protected SwiftBizRequest buildSwiftBizRequest(SwiftBizRequest bizRequest, ISwiftApiDefinition cibApiDefinitionEnum) {
        bizRequest.setSignAgentno(this.apiClientConfig.getAppId());
        bizRequest.setService(cibApiDefinitionEnum.getApiSubURI());
        bizRequest.setCharset("UTF-8");
        bizRequest.setVersion(cibApiDefinitionEnum.getVersion());
        bizRequest.setNonceStr(IdUtil.simpleUUID());
        bizRequest.setSignType(this.apiClientConfig.getSignTypeEnum().getValue());
        return bizRequest;
    }

    @Override
    protected SignParam buildSignParam(SwiftBizRequest baseRequest) {
        SignParam signParam = new SignParam();
        signParam.setAppid(this.apiClientConfig.getAppId());
        signParam.setNonceStr(RandomUtil.randomString((int)12));
        signParam.setRequest(baseRequest);
        return signParam;
    }

    @Override
    protected String serializableRequest(SwiftBizRequest baseRequest, String sign, ISwiftApiDefinition tradeApiDefinitionEnum) {
        Map<String, String> requstMap = RequestParamUtils.toMap(baseRequest);
        return RequestParamUtils.toXml(requstMap);
    }

    @Override
    protected SwiftBizResponse parseResponse(String resBody, ISwiftApiDefinition tradeApiDefinitionEnum) throws SwiftApiException {
        try {
            String xml = "<?xml version=\"1.0\" encoding=\"GBK\" standalone=\"yes\"?>" + resBody;
            Map<String, String> resMap = RequestParamUtils.getMapFromXML(xml);
            if (SwiftApiDefinitionEnum.REFUND_QUERY.equals(tradeApiDefinitionEnum)) {
                HashMap<String, String> refundMap = new HashMap<String, String>();
                refundMap.putAll(resMap);
                this.dealRefundQueryMap(refundMap);
                SwiftBizResponse swiftBizResponse = (SwiftBizResponse)RequestParamUtils.getObjectFromMap(refundMap, tradeApiDefinitionEnum.getResponseClass());
                swiftBizResponse.setResMap(resMap);
                return swiftBizResponse;
            }
            SwiftBizResponse swiftBizResponse = (SwiftBizResponse)RequestParamUtils.getObjectFromMap(resMap, tradeApiDefinitionEnum.getResponseClass());
            swiftBizResponse.setResMap(resMap);
            return swiftBizResponse;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010swiftpass-sdk\u3011\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38 >> resBody={}", e, resBody);
            throw new SwiftApiException("[swiftpass-sdk]\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38");
        }
    }

    private Map<String, String> dealRefundQueryMap(Map<String, String> map) {
        if (MapUtil.isEmpty(map)) {
            return map;
        }
        HashMap<String, String> addMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String value = entry.getValue();
            String key = entry.getKey();
            for (String filed : REFUND_QUERY_FIELD_LIST) {
                if (!key.startsWith(filed) || key.length() != filed.length() + 2 && key.length() != filed.length() + 3) continue;
                addMap.put(filed, value);
            }
        }
        if (MapUtil.isNotEmpty(addMap)) {
            map.putAll(addMap);
        }
        return map;
    }
}

