/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.swift.response.cib.trade.pay;

import com.fshows.swift.response.base.SwiftBizResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * @author wangyi
 * @version CibWxPreOrderCreateResponse.java, v 0.1 2024-09-12 17:24 wangyi
 */
@Data
public class CibWxPreOrderCreateResponse extends SwiftBizResponse implements Serializable {

    private static final long serialVersionUID = -7542020758185730493L;

    /**
     * 授权口令
     */
    private String tokenId;

    /**
     * 原生态js支付：is_raw为1时返回，json格式的字符串，作用于原生态js支付时的参数
     * 小程序支付：is_minipg为1时返回，json格式的字符串，作用于小程序支付时的参数
     */
    private String payInfo;
}