/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.swift.response.cib.trade.pay;

import com.fshows.swift.response.base.SwiftBizResponse;
import com.fshows.swift.response.trade.item.AlipayFundBillListItem;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 付款码支付response
 *
 * @author
 * @version SwiftScanCardPayResponse.java, v 0.1 2023-10-18 18:16:13
 */
@Data
public class CibScanCardPayResponse extends SwiftBizResponse implements Serializable {

    private static final long serialVersionUID = -3103019356206393912L;

    /**
     * 用来判断是否需要调用查询接口，值为Y时需要，值为N时不需要
     * (选填)
     */
    private String needQuery;

    /**
     * 门店编号，由平台分配
     * (必填)
     */
    private String mchId;

    /**
     * 终端设备号
     * (选填)
     */
    private String deviceInfo;

    /**
     * 用户在受理商户 appid 下的唯一标识
     * (选填)
     */
    private String openid;

    /**
     * 用户在子商户appid下的唯一标识
     * (选填)
     */
    private String subOpenid;

    /**
     * pay.wechat.micropay——微信付款码支付 pay.alipay.micropay——支付宝付款码支付 pay.jdpay.micropay——京东付款码支付 pay.qq.micropay——QQ钱包付款码支付 pay.shiming.micropay——会员卡付款码支付 pay.unionpay.micropay——银联付款码支付 pay.bestpay.micropay——翼支付付款码支付
     * (必填)
     */
    private String tradeType;

    /**
     * 用户是否关注公众账号，Y-关注，N-未关注，仅在公众账号类型支付有效
     * (选填)
     */
    private String isSubscribe;

    /**
     * 支付结果：0—成功；其它—失败
     * (必填)
     */
    private Integer payResult;

    /**
     * "micropay"表示反扫，"facepay"表示刷脸
     * (选填)
     */
    private String payScene;

    /**
     * 支付结果信息，支付成功时为空
     * (选填)
     */
    private String payInfo;

    /**
     * 平台交易号
     * (必填)
     */
    private String transactionId;

    /**
     * 第三方订单号
     * (必填)
     */
    private String outTransactionId;

    /**
     * 第三方商户单号，可在支持的商户扫码退款
     * (必填)
     */
    private String thirdOrderNo;

    /**
     * 用户是否关注子公众账号，Y-关注，N-未关注，仅在公众账号类型支付有效
     * (选填)
     */
    private Integer subIsSubscribe;

    /**
     * 子商户appid
     * (选填)
     */
    private String subAppid;

    /**
     * 商户系统内部的定单号，32个字符内、可包含字母
     * (必填)
     */
    private String outTradeNo;

    /**
     * 总金额，以分为单位，不允许包含任何字、符号
     * (必填)
     */
    private Integer totalFee;

    /**
     * 现金支付金额订单现金支付金额，详见支付金额
     * (选填)
     */
    private Integer cashFee;

    /**
     * 用户在交易中支付的可开发票的金额
     * (选填)
     */
    private String invoiceAmount;

    /**
     * 买家支付宝账号
     * (选填)
     */
    private String buyerLogonId;

    /**
     * 买家在支付宝的用户id
     * (选填)
     */
    private String buyerUserId;

    /**
     * 使用集分宝付款的金额
     * (选填)
     */
    private BigDecimal pointAmount;

    /**
     * 现金券支付金额<=订单总金额， 订单总金额-现金券金额为现金支付金额
     * (选填)
     */
    private Integer couponFee;

    /**
     * 优惠详情，内容详见【单品优惠活动字段说明】
     * (选填)
     */
    private String promotionDetail;

    /**
     * 优惠详情，内容详见【单品优惠活动字段说明】
     * (选填)
     */
    private String discountGoodsDetail;

    /**
     * 支付宝资金来源信息
     * (必填)
     */
    private List<AlipayFundBillListItem> fundBillList;

    /**
     * 实收金额，单位为元，两位小数。该金额为本笔交易，商户账户能够实际收到的金额
     * (必填)
     */
    private String receiptAmount;

    /**
     * 买家实付金额，单位为元，两位小数。该金额代表该笔交易买家实际支付的金额，不包含商户折扣等金额
     * (选填)
     */
    private BigDecimal buyerPayAmount;

    /**
     * 货币类型，符合 ISO 4217 标准的三位字母代码，默认人民币：CNY
     * (选填)
     */
    private String feeType;

    /**
     * 商家数据包，原样返回
     * (选填)
     */
    private String attach;

    /**
     * 银行类型
     * (选填)
     */
    private String bankType;

    /**
     * 唯一识别号
     * (选填)
     */
    private String uuid;

    /**
     * 银行订单号，若为微信支付则为空
     * (选填)
     */
    private String bankBillno;

    /**
     * 支付完成时间，格式为yyyyMMddHHmmss，如2009年12月27日9点10分10秒表示为20091227091010。时区为GMT+8 beijing。该时间取自平台服务器
     * (必填)
     */
    private String timeEnd;

    /**
     * 免充值优惠金额
     * (选填)
     */
    private Integer mdiscount;

    /**
     * 货币类型，符合 ISO 4217 标准的三位字母代码，默认人民币：CN
     * (选填)
     */
    private String cashFeeType;

    /**
     * 用户支付时间，格式为yyyyMMddHHmmss，如2009年12月27日9点10分10秒表示为20091227091010。时区为GMT+8 beijing。该时间取自平台服务器
     * (选填)
     */
    private String gmtPayment;

    /**
     * 应结订单金额=订单金额-免充值代金券金额，应结订单金额<=订单金额
     * (选填)
     */
    private Integer settlementTotalFee;

}