/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.swift.request.trade.order;

import com.fshows.swift.request.base.SwiftBizRequest;
import com.fshows.swift.response.trade.order.SwiftOrderRefundResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import javax.validation.constraints.NotNull;
import com.fshows.swift.enums.api.SwiftApiDefinitionEnum;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 订单退款申请request
 *
 * @author
 * @version SwiftOrderRefundRequest.java, v 0.1 2023-10-18 18:03:41
 */
@Data
public class SwiftOrderRefundRequest extends SwiftBizRequest<SwiftOrderRefundResponse, SwiftApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555897461183L;


    /**
     * 门店编号
     *
     * 门店编号，由平台分配
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "mchId长度不能超过32")
    private String mchId;

    /**
     * 商户订单号
     *
     * 商户系统内部的订单号, out_trade_no和transaction_id至少一个必填，同时存在时transaction_id优先
     * (选填)
     */
    @Length(max = 32, message = "outTradeNo长度不能超过32")
    private String outTradeNo;

    /**
     * 平台订单号
     *
     * 可传入平台订单号或第三方商户单号（third_order_no）, out_trade_no和transaction_id至少一个必填，同时存在时transaction_id优先
     * (选填)
     */
    @Length(max = 32, message = "transactionId长度不能超过32")
    private String transactionId;

    /**
     * 商户退款单号
     *
     * 商户退款单号，32个字符内、可包含字母,确保在商户系统唯一。同个退款单号多次请求，平台当一个单处理，只会退一次款。如果出现退款不成功，请采用原退款单号重新发起，避免出现重复退款。
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "outRefundNo长度不能超过32")
    private String outRefundNo;

    /**
     * 总金额
     *
     * 订单总金额，单位为分
     * (必填)
     */
    @NotNull
    private Integer totalFee;

    /**
     * 退款金额
     *
     * 退款总金额,单位为分,可以做部分退款
     * (必填)
     */
    @NotNull
    private Integer refundFee;

    /**
     * 操作员
     *
     * 操作员帐号,默认为商户号
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "opUserId长度不能超过32")
    private String opUserId;

    /**
     * 退款渠道
     *
     * ORIGINAL-原路退款，默认
     * (选填)
     */
    @Length(max = 16, message = "refundChannel长度不能超过16")
    private String refundChannel;

    /**
     * 设备号
     *
     * 终端设备号
     * (选填)
     */
    @Length(max = 32, message = "deviceInfo长度不能超过32")
    private String deviceInfo;

    /**
     * 退款原因
     *
     * 退款原因
     * (选填)
     */
    @Length(max = 127, message = "body长度不能超过127")
    private String body;

    /**
     * 分账退款明细
     *
     * 必须按照规范上传，JSON格式，详见“分账退款明细说明”
     * (选填)
     */
    @Length(max = 512, message = "refundProfitShareInfos长度不能超过512")
    private String refundProfitShareInfos;

}