/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.swift.request.trade.order;

import com.fshows.swift.request.base.SwiftBizRequest;
import com.fshows.swift.response.trade.order.SwiftOrderQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.swift.enums.api.SwiftApiDefinitionEnum;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 *
 *
 * @author
 * @version SwiftOrderQueryRequest.java, v 0.1 2023-10-18 17:34:25
 */
@Data
public class SwiftOrderQueryRequest extends SwiftBizRequest<SwiftOrderQueryResponse, SwiftApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555833871630L;


    /**
     * 门店编号
     *
     * 门店编号，由平台分配
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "mchId长度不能超过32")
    private String mchId;

    /**
     * 商户订单号
     *
     * 商户系统内部的订单号, out_trade_no和transaction_id至少一个必填，同时存在时transaction_id优先
     * (选填)
     */
    @Length(max = 32, message = "outTradeNo长度不能超过32")
    private String outTradeNo;

    /**
     * 平台订单号
     *
     * 可传入平台订单号或第三方商户单号（third_order_no）, out_trade_no和transaction_id至少一个必填，同时存在时transaction_id优先。
     * (选填)
     */
    @Length(max = 32, message = "transactionId长度不能超过32")
    private String transactionId;

}