package com.fshows.swift.enums.api;

import com.fshows.swift.client.base.ISwiftApiDefinition;
import com.fshows.swift.constant.SwiftConstant;
import com.fshows.swift.request.trade.order.SwiftOrderCloseRequest;
import com.fshows.swift.request.trade.order.SwiftOrderQueryRequest;
import com.fshows.swift.request.trade.order.SwiftOrderRefundRequest;
import com.fshows.swift.request.trade.order.SwiftRefundQueryRequest;
import com.fshows.swift.request.trade.pay.SwiftScanCardPayRequest;
import com.fshows.swift.request.trade.pay.SwiftTradeNativeRequest;
import com.fshows.swift.response.trade.order.SwiftOrderCloseResponse;
import com.fshows.swift.response.trade.order.SwiftOrderQueryResponse;
import com.fshows.swift.response.trade.order.SwiftOrderRefundResponse;
import com.fshows.swift.response.trade.order.SwiftRefundQueryResponse;
import com.fshows.swift.response.trade.pay.SwiftScanCardPayResponse;
import com.fshows.swift.response.trade.pay.SwiftTradeNativeResponse;

/**
 * 威富通交易相关API
 *
 * @author liluqing
 * @version SwiftApiDefinitionEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum SwiftApiDefinitionEnum implements ISwiftApiDefinition {
    PRE_ORDER_CREATE(
            "主扫交易（定额码）",
            "unified.trade.native",
            SwiftConstant.TRADE_API_VERSION_V2,
            SwiftTradeNativeRequest.class,
            SwiftTradeNativeResponse.class
    ),
    SCAN_CARD_CREATE(
            "被扫交易（付款码支付）",
            "unified.trade.micropay",
            SwiftConstant.TRADE_API_VERSION_V2,
            SwiftScanCardPayRequest.class,
            SwiftScanCardPayResponse.class
    ),
    REFUND_CREATE(
            "退款申请发起",
            "unified.trade.refund",
            SwiftConstant.TRADE_API_VERSION_V2,
            SwiftOrderRefundRequest.class,
            SwiftOrderRefundResponse.class
    ),
    REFUND_QUERY(
            "退款查询接口",
            "unified.trade.refundquery",
            SwiftConstant.TRADE_API_VERSION_V2,
            SwiftRefundQueryRequest.class,
            SwiftRefundQueryResponse.class
    ),
    ORDER_CLOSE(
            "关单交易",
            "unified.trade.close",
            SwiftConstant.TRADE_API_VERSION_V2,
            SwiftOrderCloseRequest.class,
            SwiftOrderCloseResponse.class
    ),
    ORDER_QUERY(
            "订单查询接口",
            "unified.trade.query",
            SwiftConstant.TRADE_API_VERSION_V2,
            SwiftOrderQueryRequest.class,
            SwiftOrderQueryResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本号
     */
    private String version;
    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;


    SwiftApiDefinitionEnum(String name,
                           String apiSubURI,
                           String version,
                           Class requestClass,
                           Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiSubURI() {
        return apiSubURI;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}