/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.swift.client.impl;

import com.fshows.swift.client.base.ApiClientConfig;
import com.fshows.swift.client.base.IHttpRequest;
import com.fshows.swift.client.base.ISigner;
import com.fshows.swift.client.base.ISwiftApiClient;
import com.fshows.swift.client.base.ISwiftApiDefinition;
import com.fshows.swift.client.base.SignParam;
import com.fshows.swift.client.base.SwiftHttpResult;
import com.fshows.swift.client.impl.http.DefaultHttpRequestImpl;
import com.fshows.swift.client.impl.signer.DefaultSignerImpl;
import com.fshows.swift.exception.SwiftApiException;
import com.fshows.swift.request.base.SwiftBizRequest;
import com.fshows.swift.response.base.SwiftBizResponse;
import com.fshows.swift.util.LogUtil;
import com.fshows.swift.util.ValidateUtil;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSwiftApiClientImpl
implements ISwiftApiClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractSwiftApiClientImpl.class);
    protected ApiClientConfig apiClientConfig;
    protected IHttpRequest httpRequest;
    protected ISigner signer;

    public AbstractSwiftApiClientImpl(ApiClientConfig apiClientConfig) throws SwiftApiException {
        ValidateUtil.validateWithThrow(apiClientConfig, new Class[0]);
        this.apiClientConfig = apiClientConfig;
        this.httpRequest = new DefaultHttpRequestImpl();
        this.signer = new DefaultSignerImpl();
    }

    public AbstractSwiftApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws SwiftApiException {
        ValidateUtil.validateWithThrow(apiClientConfig, new Class[0]);
        this.apiClientConfig = apiClientConfig;
        this.httpRequest = httpRequest;
        this.signer = signer;
    }

    protected SwiftBizResponse doExecute(SwiftBizRequest bizRequest, ISwiftApiDefinition tradeApiDefinitionEnum) throws SwiftApiException {
        try {
            boolean bo;
            this.checkParam(bizRequest, tradeApiDefinitionEnum);
            this.buildSwiftBizRequest(bizRequest, tradeApiDefinitionEnum);
            SignParam signParam = this.buildSignParam(bizRequest);
            String sign = this.signer.sign(signParam, this.apiClientConfig);
            bizRequest.setSign(sign);
            String body = this.serializableRequest(bizRequest, sign, tradeApiDefinitionEnum);
            String url = this.getServerURL(tradeApiDefinitionEnum);
            SwiftHttpResult httpResult = this.requestPost(url, sign, body);
            SwiftBizResponse response = this.parseResponse(httpResult.getBody(), tradeApiDefinitionEnum);
            LogUtil.info(log, "\u3010swiftpass-sdk\u3011\u54cd\u5e94\u7ed3\u679c\u6620\u5c04\u7ed3\u675f >> url={}, request={}, response={}", url, bizRequest, response);
            if (this.apiClientConfig.isVrifySignResponse() && response != null && StringUtils.equals((CharSequence)response.getStatus(), (CharSequence)"0") && !(bo = this.signer.verifySign(response.getResMap(), null, this.apiClientConfig).booleanValue())) {
                LogUtil.error(log, "\u3010swiftpass-sdk\u3011\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25 >> httpResult={}", httpResult);
                throw new SwiftApiException("[swiftpass-sdk]\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25");
            }
            return response;
        }
        catch (SwiftApiException e) {
            LogUtil.error(log, "\u3010swiftpass-sdk\u3011\u5a01\u5bcc\u901a\u8bf7\u6c42\u5f02\u5e38 >> tradeApiDefinition={}, bizRequest={}", e, tradeApiDefinitionEnum, bizRequest);
            throw e;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010swiftpass-sdk\u3011\u5a01\u5bcc\u901a\u8bf7\u6c42\u5f02\u5e38 >> tradeApiDefinition={}, bizRequest={}", e, tradeApiDefinitionEnum, bizRequest);
            throw new SwiftApiException(e.getMessage(), e);
        }
    }

    protected SwiftHttpResult requestPost(String url, String authorization, String requestBody) throws IOException, SwiftApiException {
        long beginTime = System.currentTimeMillis();
        try {
            LogUtil.info(log, "\u3010swiftpass-sdk\u3011\u8bf7\u6c42\u5f00\u59cb >> url={}, authorization={}, request={}", url, authorization, requestBody);
            SwiftHttpResult httpResult = this.httpRequest.post(url, authorization, requestBody, this.apiClientConfig);
            if (httpResult == null) {
                throw new SwiftApiException("swiftpass\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a");
            }
            LogUtil.info(log, "\u3010swiftpass-sdk\u3011\u8bf7\u6c42\u7ed3\u675f >> url={}, request={}, response={}, cost={}ms", url, requestBody, httpResult.getBody(), System.currentTimeMillis() - beginTime);
            return httpResult;
        }
        catch (SwiftApiException e) {
            LogUtil.error(log, "\u3010swiftpass-sdk\u3011\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38 >> url={}, request={}, cost={}ms", e, url, requestBody, System.currentTimeMillis() - beginTime);
            throw e;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010swiftpass-sdk\u3011\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38 >> url={}, request={}, cost={}ms", e, url, requestBody, System.currentTimeMillis() - beginTime);
            throw new SwiftApiException("\u8bf7\u6c42swiftpass\u63a5\u53e3\u5f02\u5e38", e);
        }
    }

    protected void checkParam(SwiftBizRequest bizRequest, ISwiftApiDefinition swiftApiDefinition) throws SwiftApiException {
        ValidateUtil.notNull(bizRequest, "request\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        System.out.println();
        boolean checkRequestClass = StringUtils.equals((CharSequence)bizRequest.getClass().getCanonicalName(), (CharSequence)swiftApiDefinition.getRequestClass().getCanonicalName());
        if (!checkRequestClass) {
            throw new SwiftApiException("\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        if (this.apiClientConfig.isCheckParam()) {
            ValidateUtil.validateWithThrow(bizRequest, new Class[0]);
        }
    }

    protected String getServerURL(ISwiftApiDefinition tradeApiDefinitionEnum) {
        return this.apiClientConfig.getApiParentURL();
    }

    protected abstract SwiftBizRequest buildSwiftBizRequest(SwiftBizRequest var1, ISwiftApiDefinition var2);

    protected abstract SignParam buildSignParam(SwiftBizRequest var1);

    protected abstract String serializableRequest(SwiftBizRequest var1, String var2, ISwiftApiDefinition var3);

    protected abstract SwiftBizResponse parseResponse(String var1, ISwiftApiDefinition var2) throws SwiftApiException;

    public void setApiClientConfig(ApiClientConfig apiClientConfig) {
        this.apiClientConfig = apiClientConfig;
    }

    public void setHttpRequest(IHttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public void setSigner(ISigner signer) {
        this.signer = signer;
    }
}

