/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.swift.client.impl.signer;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.MD5;
import com.fshows.swift.client.base.ApiClientConfig;
import com.fshows.swift.client.base.ISigner;
import com.fshows.swift.client.base.SignParam;
import com.fshows.swift.client.base.VerifySignParam;
import com.fshows.swift.exception.SwiftApiException;
import com.fshows.swift.request.base.SwiftBizRequest;
import com.fshows.swift.util.LogUtil;
import com.fshows.swift.util.RequestParamUtils;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSignerImpl
implements ISigner {
    private static final Logger log = LoggerFactory.getLogger(DefaultSignerImpl.class);

    public static String getWaitSignStr(Map<String, String> dataMap, ApiClientConfig apiClientConfig) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : dataMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.equals((CharSequence)key, (CharSequence)"sign") || StringUtils.startsWith((CharSequence)key, (CharSequence)"reserved") || StrUtil.isBlank((CharSequence)value)) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(key).append("=").append(value);
        }
        sb.append("&key=").append(apiClientConfig.getPayCompanyPublicKey());
        return sb.toString();
    }

    public static void main(String[] args) {
        ApiClientConfig apiClientConfig = new ApiClientConfig();
        apiClientConfig.setPayCompanyPublicKey("040f23510fbf4b34ae3895272e83c58c");
        String privateKey = "040f23510fbf4b34ae3895272e83c58c";
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("name", "111111");
        map.put("age", "222222");
        String waitSignStr = DefaultSignerImpl.getWaitSignStr(map, apiClientConfig);
        System.out.println(waitSignStr + "\n\n\n");
        String digestHex = MD5.create().digestHex(waitSignStr);
        System.out.println(digestHex);
        map.put("sign", digestHex);
        System.out.println("\n\n\n" + RequestParamUtils.generateXml(map));
    }

    @Override
    public String sign(SignParam signParam, ApiClientConfig apiClientConfig) throws SwiftApiException {
        return this.doSign(signParam, apiClientConfig);
    }

    @Override
    public Boolean verifySign(Map<String, String> resMap, VerifySignParam verifySignParam, ApiClientConfig apiClientConfig) throws SwiftApiException {
        try {
            String waitSignStr = DefaultSignerImpl.getWaitSignStr(resMap, apiClientConfig);
            String resSign = resMap.get("sign");
            return resSign.equals(DefaultSignerImpl.getWaitSignStr(resMap, apiClientConfig));
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010swiftpass-sdk\u3011\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25 >> signParam={}", e, verifySignParam);
            throw new SwiftApiException("swiftpass\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25", e);
        }
    }

    public String doSign(SignParam signParam, ApiClientConfig apiClientConfig) throws SwiftApiException {
        try {
            SwiftBizRequest request = signParam.getRequest();
            Map<String, String> data = RequestParamUtils.toMap(request, apiClientConfig.isHump());
            String waitSignStr = DefaultSignerImpl.getWaitSignStr(data, apiClientConfig);
            LogUtil.info(log, "\u3010swiftpass-sdk\u3011\u5f85\u52a0\u7b7e\u5b57\u7b26\u4e32 >> waitSignStr={}", waitSignStr);
            String md5Hex = DigestUtils.md5Hex((byte[])waitSignStr.getBytes(apiClientConfig.getCharset()));
            return md5Hex.toLowerCase();
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010swiftpass-sdk\u3011\u8bf7\u6c42\u52a0\u7b7e\u5931\u8d25 >> signParam={}", e, signParam);
            throw new SwiftApiException("swiftpass\u8bf7\u6c42\u52a0\u7b7e\u5931\u8d25", e);
        }
    }
}

