/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.swift.client.impl;

import cn.hutool.core.util.RandomUtil;
import com.fshows.swift.client.base.ApiClientConfig;
import com.fshows.swift.client.base.IHttpRequest;
import com.fshows.swift.client.base.ISigner;
import com.fshows.swift.client.base.ISwiftApiDefinition;
import com.fshows.swift.client.base.SignParam;
import com.fshows.swift.client.impl.AbstractSwiftApiClientImpl;
import com.fshows.swift.exception.SwiftApiException;
import com.fshows.swift.request.base.SwiftBizRequest;
import com.fshows.swift.response.base.SwiftBizResponse;
import com.fshows.swift.util.LogUtil;
import com.fshows.swift.util.RequestParamUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradeSwiftApiClientImpl
extends AbstractSwiftApiClientImpl {
    private static final Logger log = LoggerFactory.getLogger(TradeSwiftApiClientImpl.class);

    public TradeSwiftApiClientImpl(ApiClientConfig apiClientConfig) throws SwiftApiException {
        super(apiClientConfig);
    }

    public TradeSwiftApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws SwiftApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    @Override
    public <T extends SwiftBizResponse, R extends ISwiftApiDefinition> T execute(SwiftBizRequest<T, R> request, R tradeApiDefinitionEnum) throws SwiftApiException {
        return (T)super.doExecute(request, tradeApiDefinitionEnum);
    }

    @Override
    protected SwiftBizRequest buildSwiftBizRequest(SwiftBizRequest bizRequest, ISwiftApiDefinition tradeApiDefinitionEnum) {
        return bizRequest;
    }

    @Override
    protected SignParam buildSignParam(SwiftBizRequest baseRequest) {
        SignParam signParam = new SignParam();
        signParam.setAppid(this.apiClientConfig.getAppId());
        signParam.setNonceStr(RandomUtil.randomString((int)12));
        signParam.setRequest(baseRequest);
        return signParam;
    }

    @Override
    protected String serializableRequest(SwiftBizRequest baseRequest, String sign, ISwiftApiDefinition tradeApiDefinitionEnum) {
        Map<String, String> requstMap = RequestParamUtils.toMap(baseRequest);
        return RequestParamUtils.generateXml(requstMap);
    }

    @Override
    protected SwiftBizResponse parseResponse(String resBody, ISwiftApiDefinition tradeApiDefinitionEnum) throws SwiftApiException {
        try {
            Map<String, String> resMap = RequestParamUtils.getMapFromXML(resBody);
            SwiftBizResponse swiftBizResponse = (SwiftBizResponse)RequestParamUtils.getObjectFromMap(resMap, tradeApiDefinitionEnum.getResponseClass());
            swiftBizResponse.setResMap(resMap);
            return swiftBizResponse;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010swiftpass-sdk\u3011\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38 >> resBody={}", e, resBody);
            throw new SwiftApiException("[swiftpass-sdk]\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38");
        }
    }
}

