/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.response.merchant;

import com.fshows.shande.sdk.response.merchant.item.ShandeEntryFailureMsgsResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 个人用户进件响应结果
 *
 * @author
 * @version ShandeCusApplicationsOpenResponse.java, v 0.1 2022-12-06 14:03:34
 */
@Data
public class ShandeCusApplicationsOpenResponse implements Serializable {

    private static final long serialVersionUID = -2213838555114436486L;


    /**
     * 进件状态
     * 枚举值：checking：资料校验中 account_need_verify：待账户验证（四要素鉴权） auditing：审核中 processing：处理中 signing: 电子签约中 succeeded：已通过 failed：被驳回
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "applicationStatus长度不能超过20")
    private String applicationStatus;

    /**
     * 个人用户
     * 当进件状态为 succeeded 时返
     *
     * (特殊必填)
     */
    @Length(max = 19, message = "cusId长度不能超过19")
    private String cusId;

    /**
     * 进件申请通过时间
     * 当进件状态为 succeeded 时返回。格式: RFC3339
     *
     * (特殊必填)
     */
    private String succeededAt;

    /**
     * 进件申请失败时间
     * 当进件状态为 failed 时返回。格式: RFC3339
     *
     * (特殊必填)
     */
    private String failedAt;

    /**
     * 审核失败原因
     * 进件状态为 failed 或 frozen时，且字段有值时返回
     * <p>
     * (特殊必填)
     */
    private List<ShandeEntryFailureMsgsResponse> failureMsgs;

    /**
     * 电子账簿账簿号
     * 1、当进件状态为succeeded 时返回2、由系统生成的电子账簿账簿号，可作为收款信息，用于接收外部转账3、仅首次进件返回4、可能存在与用户 ID、电子账簿 ID、绑定账户 ID 无法同时生成的情况，需要再次通过查询接口获取
     *
     * (特殊必填)
     */
    @Length(max = 24, message = "relAcctNo长度不能超过24")
    private String relAcctNo;

    /**
     * 银行生成的
     * 当通过 rel_acct_no 进行虚户绑定时银行返回的虚户名称
     *
     * (特殊必填)
     */
    @Length(max = 64, message = "bindAcctNa长度不能超过64")
    private String bindAcctName;

    /**
     * 电子账簿 ID
     * 1、当进件状态为succeeded 时返回2、仅首次进件返回
     *
     * (特殊必填)
     */
    @Length(max = 19, message = "balanceAcctId长度不能超过19")
    private String balanceAcctId;

    /**
     * 绑定账户 ID
     * 当进件状态为 succeeded 时返回
     *
     * (特殊必填)
     */
    @Length(max = 24, message = "settleAcctId长度不能超过24")
    private String settleAcctId;

    /**
     * 平台订单号
     * 1、平台自定义的唯一编号2、每个平台订单号对应一个系统订单号，每个系统订单号创建成功后会生成一个个人用户 ID3、若系统订单号为“失败”，可使用相同的“平台订单号”再次请求，覆盖原申请单信息4、要求 64 个字符内，只能是数字、大小写字母和_-
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "outRequestNo长度不能超过64")
    private String outRequestNo;

    /**
     * 系统订单号
     * 申请单的主键，唯一定义此资源的标识
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "cusApplicationId长度不能超过19")
    private String cusApplicationId;

    /**
     * 自定义参数
     * {"description":"123456"}
     *
     * (选填)
     */
    private Map<String,Object> metadata;

    /**
     * 额外信息
     * 按管理后台配置情况填写
     * extra[contractNo] 合同编号
     *
     * (选填)
     */
    private Map<String,String> extra;

}