/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.shande.sdk.request.merchant.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 税务登记证
 *
 * @author liluqing
 * @version ShandeBeneficiaryIdCardRequest.java, v 0.1 2022-12-06 14:43
 */
@Data
public class ShandeTaxRegistrationCertRequest implements Serializable {

    private static final long serialVersionUID = -2213838555911708488L;

    /**
     * 税务登记证照片
     * 1、可上传 1 张图片，请填写通过[图片上传接口预先上传图片生成好的 media_id
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 255, message = "copy长度不能超过255")
    private String copy;

    /**
     * 税务登记号
     * 1、请填写税务登记证上的税务登记号2、填写 15 或 18位数字
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 18, message = "number长度不能超过18")
    private String number;
}