/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.shande.sdk.request.merchant.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 组织机构代码证
 *
 * @author liluqing
 * @version ShandeBeneficiaryIdCardRequest.java, v 0.1 2022-12-06 14:43
 */
@Data
public class ShandeOrganizationCertRequest implements Serializable {

    private static final long serialVersionUID = -2213838555911708488L;

    /**
     * 组织机构代码证照片
     * 1、可上传 1 张图片，请填写通过[图片上传接口预先上传图片生成好的 media_id
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 255, message = "copy长度不能超过255")
    private String copy;

    /**
     * 组织机构代码
     * 1、请填写组织机构代码证上的组织机构代码 2、可填写 9 或 10位数字、字母、连字符
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 10, message = "number长度不能超过10")
    private String number;

    /**
     * 组织机构代码有效期限
     * 1、若证件有效期为长期，到期时间请填写：长期2、到期时间需晚于成立时间3、有效期必须大于60 天，即结束时间距当前时间需超过 60 天4、格式：1990-01-01，长期
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "organizationCe长度不能超过32")
    private String validTime;
}