/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.shande.sdk.request.merchant.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 绑定账户信息
 *
 * @author liluqing
 * @version ShandeApplicationsSettleAcctRequest.java, v 0.1 2022-12-06 14:10
 */
@Data
public class ShandeApplicationsSettleAcctRequest implements Serializable {

    private static final long serialVersionUID = -2213838555911708488L;

    /**
     * 账户类型
     * 1、若主体为企业，可填写：2 - 对公账户2、若主体为个体工商户，可填写：- 对私账户；2 - 对公账户
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "type长度不能超过1")
    private String type;

    /**
     * 开户银行编码
     * 1、若账户类型为 1 -对私账户时，非必传2、账户类型为 2 - 对公账户时，必传3、详细参见：[开户银行联行号表drec_code 字段
     *
     * (特殊必填)
     */
    @Length(max = 12, message = "bankCode长度不能超过12")
    private String bankCode;

    /**
     * 开户名称
     * 1、选择对私账户时，开户名称必须与法人身份证姓名一致2、选择对公账户时，开户名称必须与营业执照上的“注册名称”一致
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "name长度不能超过64")
    private String name;

    /**
     * 开户银行省市编码
     * 至少精确到市，详细参见：[省市区编号对照表
     *
     * (选填)
     */
    @Length(max = 6, message = "bankAddressCode长度不能超过6")
    private String bankAddressCode;

    /**
     * 开户银行联行号
     * 1、若账户类型为 1 -对私账户时，非必传2、若账户类型为 2 -对公账户时，必传3、详细参见：[开户银行联行表bank_code 字段
     *
     * (特殊必填)
     */
    @Length(max = 12, message = "bankBranchCode长度不能超过12")
    private String bankBranchCode;

    /**
     * 银行帐号
     *
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 34, message = "bankAcctNo长度不能超过34")
    private String bankAcctNo;
    /**
     * 职位
     * 详细参见：[职业信息表]
     */
    private String profession;
}