/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.merchant;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import com.fshows.shande.sdk.request.ShandeRequest;

/**
 * 个人用户进件状态查询入参
 *
 * @author
 * @version ShandeCusApplicationsQueryRequest.java, v 0.1 2022-12-06 14:26:25
 */
@Data
public class ShandeCusApplicationsQueryRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555380132548L;


    /**
     * 系统订单号-个人用户进件
     * 1、唯一定义此资源的标识2、和平台订单号二选一
     *
     * (特殊必填)
     */
    @Length(max = 19, message = "cusApplicationId长度不能超过19")
    private String cusApplicationId;

    /**
     * 平台订单号
     * 1、平台自定义的唯一编号2、每个平台订单号对应一个系统订单号，每个系统订单号创建成功后会生成一个个人用户 ID3、若申请单审核“失败”，可使用相同的“平台订单号”再次请求，修改原申请单信息4、要求 64 个字符内，只能是数字、大小写字母和_-5、和系统订单号二选一
     *
     * (特殊必填)
     */
    @Length(max = 64, message = "outRequestNo长度不能超过64")
    private String outRequestNo;

}