/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.merchant;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import com.fshows.shande.sdk.request.ShandeRequest;

/**
 * 查询用户或二级商户是否进件入参
 *
 * @author
 * @version ShandeApplicationsQueryRequest.java, v 0.1 2022-12-06 11:47:41
 */
@Data
public class ShandeApplicationsQueryRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555911708488L;


    /**
     * 证件号码
     * 证件号码和营业执照注册号选一填写
     *
     * (特殊必填)
     */
    @Length(max = 64, message = "idCardNumber长度不能超过64")
    private String idCardNumber;

    /**
     * 营业执照注册号
     * 证件号码和营业执照注册号选一填写
     *
     * (特殊必填)
     */
    @Length(max = 18, message = "businessLicenseNumber长度不能超过18")
    private String businessLicenseNumber;

}