/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.books;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import com.fshows.shande.sdk.request.ShandeRequest;

/**
 * 打款验证（绑定账户编码）入参
 *
 * @author
 * @version ShandeSettleValidateRequest.java, v 0.1 2022-12-06 10:53:20
 */
@Data
public class ShandeSettleValidateRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555734352176L;


    /**
     * 绑定账户编号
     * 系统生成的唯一编号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "settleAcctId长度不能超过19")
    private String settleAcctId;

    /**
     * 打款验证金额
     * 收到银行用于验证的金额，单位分
     *
     * (必填)
     */
    @NotNull
    private Integer payAmount;
}