/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.books;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import com.fshows.shande.sdk.request.ShandeRequest;

/**
 * 电子账簿流水查询入参
 *
 * @author
 * @version ShandeBalanceTransactionsRequest.java, v 0.1 2022-12-06 11:54:32
 */
@Data
public class ShandeBalanceTransactionsRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555467317886L;


    /**
     * 电子账簿ID
     * 系统生成的电子账簿唯一ID
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "balanceAcctId长度不能超过19")
    private String balanceAcctId;

    /**
     * 开始时间
     * 格式: RFC3339
     *
     * (选填)
     */
    @Length(max = 25, message = "startAt长度不能超过25")
    private String startAt;

    /**
     * 结束时间
     * 格式: RFC3339
     *
     * (选填)
     */
    @Length(max = 25, message = "endAt长度不能超过25")
    private String endAt;

    /**
     * 游标
     * 
     *
     * (选填)
     */
    @Length(max = 200, message = "cursor长度不能超过200")
    private String cursor;

    /**
     * 每页条数
     * 
     *
     * (选填)
     */
    private Integer size;

    /**
     * 系统订单号
     * 
     *
     * (选填)
     */
    @Length(max = 19, message = "tradeId长度不能超过19")
    private String tradeId;

}