/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.shande.sdk.request.account;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;

import com.fshows.shande.sdk.request.ShandeRequest;

/**
 * 查询绑定账户入参
 *
 * @author
 * @version ShandeAccountQueryBindingRequest.java, v 0.1 2022-12-06 13:53:18
 */
@Data
public class ShandeAccountQueryBindingRequest extends ShandeRequest {

    private static final long serialVersionUID = -2213838555296101203L;


    /**
     * 绑定账户编号
     * 1、系统生成的唯一编号2、绑定账户编号和平台订单号二选一
     *
     * (特殊必填)
     */
    @Length(max = 19, message = "settleAcctId长度不能超过19")
    private String settleAcctId;

    /**
     * 平台订单号
     * 1、平台自定义的唯一编号2、要求 64 个字符 内，只能是数字、大小写字母和_-3、用户进件时新增的绑定账户信息，请通过使用申请进件时的平台订单号进行查询4、绑定账户编号和平台订单号二选一
     *
     * (特殊必填)
     */
    @Length(max = 64, message = "outRequestNo长度不能超过64")
    private String outRequestNo;

}