/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.shande.sdk.common;


import com.fshows.com.shande.openapi.sdk.constant.RequestVerifyTypeEnum;
import com.fshows.shande.sdk.request.account.ShandeAccountAddBindingRequest;
import com.fshows.shande.sdk.request.account.ShandeAccountDeleteBindingRequest;
import com.fshows.shande.sdk.request.account.ShandeAccountQueryBindingRequest;
import com.fshows.shande.sdk.request.books.*;
import com.fshows.shande.sdk.request.common.ShandeAcctPasswordsRequest;
import com.fshows.shande.sdk.request.common.ShandePersonalValidationSmsRequest;
import com.fshows.shande.sdk.request.common.ShandeUploadImageRequest;
import com.fshows.shande.sdk.request.fund.*;
import com.fshows.shande.sdk.request.merchant.*;
import com.fshows.shande.sdk.response.account.ShandeAccountAddBindingResponse;
import com.fshows.shande.sdk.response.account.ShandeAccountDeleteBindingResponse;
import com.fshows.shande.sdk.response.account.ShandeAccountQueryBindingResponse;
import com.fshows.shande.sdk.response.books.*;
import com.fshows.shande.sdk.response.common.ShandeAcctPasswordsResponse;
import com.fshows.shande.sdk.response.common.ShandePersonalValidationSmsResponse;
import com.fshows.shande.sdk.response.common.ShandeUploadImageResponse;
import com.fshows.shande.sdk.response.fund.*;
import com.fshows.shande.sdk.response.merchant.*;
import org.apache.commons.lang3.StringUtils;

/**
 * shande api 枚举
 *
 * @author linzy
 * @version ShandeApiEnum.java, v 0.1 2022-12-02 10:33 linzy
 */
public enum ShandeApiEnum {
    /**
     * 进件相关
     */
    CUS_OPEN("个人用户进件",
            "/merchant/cus_applications_open", RequestVerifyTypeEnum.ACCOUNT_OPENING, ShandeCusApplicationsOpenRequest.class, ShandeCusApplicationsOpenResponse.class),
    CUS_QUERY("个人用户进件状态查询",
            "/merchant/cus_applications_query", RequestVerifyTypeEnum.ACCOUNT_OPENING, ShandeCusApplicationsQueryRequest.class, ShandeCusApplicationsOpenResponse.class),
    CUS_APPLICATIONS_RENEW("个人用户信息修改",
            "/merchant/cus_applications_renew", RequestVerifyTypeEnum.ACCOUNT_OPENING, ShandeCusApplicationsRenewRequest.class, ShandeCusApplicationsOpenResponse.class),
    APPLICATIONS_QUERY("查询用户或二级商户是否进件(申请单查询)",
            "/merchant/applications_query", RequestVerifyTypeEnum.ACCOUNT_OPENING, ShandeApplicationsQueryRequest.class, ShandeApplicationsQueryResponse.class),
    APPLICATIONS_SUBMCH_ADD("二级商户（企业用户）进件",
            "/merchant/mch_applications_open", RequestVerifyTypeEnum.ACCOUNT_OPENING, ShandeApplicationsSubmchAddRequest.class, ShandeApplicationsSubmchAddResponse.class),
    APPLICATIONS_SUBMCH_UPDATE("二级商户信息修改",
            "/merchant/mch_applications_renew", RequestVerifyTypeEnum.ACCOUNT_OPENING, ShandeApplicationsSubmchUpdateRequest.class, ShandeApplicationsSubmchUpdateResponse.class),
    APPLICATIONS_SUBMCH_QUERY("二级商户进件状态查询",
            "/merchant/mch_applications_query", RequestVerifyTypeEnum.ACCOUNT_OPENING, ShandeApplicationsSubmchQueryRequest.class, ShandeApplicationsSubmchQueryResponse.class),


    /**
     * 账户相关
     */
    ACCOUNT_DELETE_BINDING("删除绑定账户",
            "/merchant/delete_settle_accts", RequestVerifyTypeEnum.ACCOUNT_OPENING, ShandeAccountDeleteBindingRequest.class, ShandeAccountDeleteBindingResponse.class),
    ACCOUNT_QUERY_BINDING("查询绑定账户",
            "/merchant/settle_accts_query", RequestVerifyTypeEnum.ACCOUNT_OPENING, ShandeAccountQueryBindingRequest.class, ShandeAccountQueryBindingResponse.class),
    ACCOUNT_ADD_BINDING("新增绑定账户",
            "/merchant/add_settle_accts", RequestVerifyTypeEnum.ACCOUNT_OPENING, ShandeAccountAddBindingRequest.class, ShandeAccountAddBindingResponse.class),

    /**
     * 电子账簿相关api
     */
    ACCOUNT_BOOKS_ADD("新增电子账簿",
            "/merchant/balance_accts", RequestVerifyTypeEnum.ACCOUNT_OPENING, ShandeAccountBookAddRequest.class, ShandeAccountBookAddResponse.class),
    ACCOUNT_BOOKS_QUERY_BY_BOOKID("电子账簿查询（电子账簿 ID）",
            "/merchant/balance_accts_query", RequestVerifyTypeEnum.ACCOUNT_OPENING, ShandeBookQueryByBookidRequest.class, ShandeBookQueryByBookidResponse.class),
    ACCOUNT_BOOKS_QUERY_BY_MERCHANTNO("电子账簿查询（用户 ID）",
            "/merchant/balance_accts_query", RequestVerifyTypeEnum.ACCOUNT_OPENING, ShandeBookQueryByMchIdRequest.class, ShandeBookQueryByMchIdResponse.class),
    SETTLE_ACCTS_VALIDATE("打款验证（绑定账户编码）",
            "/merchant/settle_accts_validate", RequestVerifyTypeEnum.ACCOUNT_OPENING, ShandeSettleValidateRequest.class, ShandeSettleValidateResponse.class),
    ELECTRONIC_RECEIPTS_QUERY("电子回单生成（查询）",
            "/merchant/electronic_receipts_query", RequestVerifyTypeEnum.ACCOUNT_OPENING, ShandeElectronicReceiptsQueryRequest.class, ShandeElectronicReceiptsQueryResponse.class),
    BALANCE_TRANSACTIONS("电子账簿流水查询",
            "/merchant/balance_transactions", RequestVerifyTypeEnum.ACCOUNT_OPENING, ShandeBalanceTransactionsRequest.class, ShandeBalanceTransactionsResponse.class),


    /**
     * 其他
     */
    PERSONAL_VALIDATION_SMS("个人用户手机号验证",
            "/merchant/personal_validation_sms_codes", RequestVerifyTypeEnum.ACCOUNT_OPENING, ShandePersonalValidationSmsRequest.class, ShandePersonalValidationSmsResponse.class),
    UPLOAD_IMAGE("上传图片",
            "/merchant/uploadimage", RequestVerifyTypeEnum.ACCOUNT_OPENING, ShandeUploadImageRequest.class, ShandeUploadImageResponse.class),
    ACCT_PASSWORDS("中台监管账户交易密码",
            "/merchant/acct_passwords", RequestVerifyTypeEnum.ACCOUNT_OPENING, ShandeAcctPasswordsRequest.class, ShandeAcctPasswordsResponse.class),


    /**
     * 交易入金类相关api
     */
    FUND_IN_DEPOSITS("支付充值",
            "/in/deposits", RequestVerifyTypeEnum.IN_FUND,ShandeDepositsInRequest.class, ShandeDepositsInResponse.class),
    FUND_IN_DEPOSITS_QUERY("充值订单查询",
            "/in/deposits_query", RequestVerifyTypeEnum.IN_FUND,ShandeDepositsQueryInRequest.class, ShandeDepositsQueryInResponse.class),

    /**
     * 交易出金类相关api
     */
    FUND_OUT_WITHDRAWALS("提现创建",
            "/out/withdrawals", RequestVerifyTypeEnum.OUT_FUND,ShandeFundWithdrawalsOutRequest.class, ShandeFundWithdrawalsOutResponse.class),
    FUND_OUT_WITHDRAWALS_QUERY("提现订单查询",
            "/out/withdrawals_query", RequestVerifyTypeEnum.OUT_FUND,ShandeFundWithdrawalsQueryRequest.class, ShandeFundWithdrawalsQueryOutResponse.class),
    FUND_OUT_PAYMENTS("消费（转账）",
            "/out/payments", RequestVerifyTypeEnum.OUT_FUND,ShandeFundPaymentsOutRequest.class, ShandeFundPaymentsOutResponse.class),
    FUND_OUT_PAYMENTS_QUERY("消费（转账）订单查询",
            "/out/payments_query", RequestVerifyTypeEnum.OUT_FUND,ShandeFundPaymentsOutQueryRequest.class, ShandeFundPaymentsQueryOutResponse.class),
    FUND_OUT_BALANCE_PAYMENTS_ADD("配置电子账簿关联关系",
            "/out/balance_payments_add", RequestVerifyTypeEnum.OUT_FUND,ShandeFundBalancePaymentsAddOutRequest.class, ShandeFundBalancePaymentsAddOutResponse.class),
    FUND_OUT_BALANCE_PAYMENTS_QUERY("查询可以转账的电子账簿",
            "/out/balance_payments_query", RequestVerifyTypeEnum.OUT_FUND,ShandeFundBalancePaymentsQueryOutRequest.class, ShandeFundBalancePaymentsQueryOutResponse.class),
    FUND_OUT_BALANCE_PAYMENTS_DELETE("删除电子账簿关联关系",
            "/out/balance_payments_delete", RequestVerifyTypeEnum.OUT_FUND,ShandeFundBalancePaymentsDeleteOutRequest.class, ShandeFundBalancePaymentsDeleteOutResponse.class),
    FUND_OUT_BALANCE_PAYMENTS_SMS_CODE("获取新增电子账簿短信验证码",
            "/out/balance_payments_sms_code", RequestVerifyTypeEnum.OUT_FUND,ShandeFundBalancePaymentsSmsCodeOutRequest.class, ShandeFundBalancePaymentsSmsCodeOutResponse.class),
    FUND_OUT_ALLOCATIONS("分账（批量转账）",
            "/out/allocations", RequestVerifyTypeEnum.OUT_FUND,ShandeFundAllocationsOutRequest.class, ShandeFundAllocationsOutResponse.class),
    FUND_OUT_ALLOCATIONS_QUERY("分账（批量转账）订单查询",
            "/out/allocations_query", RequestVerifyTypeEnum.OUT_FUND,ShandeFundAllocationsQueryOutRequest.class, ShandeFundAllocationsQueryOutResponse.class),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口子路径
     */
    private String value;
    /**
     * 请求验证类型
     * 开户、出金、入金 使用不同公私钥，通过此标识区分
     */
    private RequestVerifyTypeEnum verifyTypeEnum;
    /**
     * 请求参数类型
     */
    private Class requestClass;
    /**
     * 响应参数类型
     */
    private Class responseClass;

    ShandeApiEnum(String name, String value, RequestVerifyTypeEnum verifyTypeEnum, Class requestClass, Class responseClass) {
        this.name = name;
        this.value = value;
        this.verifyTypeEnum = verifyTypeEnum;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static ShandeApiEnum getByValue(String value) {
        ShandeApiEnum[] valueList = ShandeApiEnum.values();
        for (ShandeApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    public Class getRequestClass() {
        return requestClass;
    }

    public Class getResponseClass() {
        return responseClass;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    public RequestVerifyTypeEnum getVerifyTypeEnum() {
        return verifyTypeEnum;
    }

}
