/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.remit.agent.response.remit;

import com.fshows.remit.agent.response.ShandeBizResponse;
import lombok.Data;

import javax.naming.directory.SearchResult;
import java.io.Serializable;

/**
 * 杉德代付返回接口
 *
 * @author liluqing
 * @version ShandeAgentPayResponse.java, v 0.1 2023-09-20 14:32
 */
@Data
public class ShandeAgentPayResponse extends ShandeBizResponse implements Serializable {

    private static final long serialVersionUID = 2781695855884327450L;

    /**
     * 交易时间
     */
    private String tranTime;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 处理状态
     * 0-  成功
     * 1-  失败
     * 2-  处理中(等银行返回明确结果)
     */
    private String resultFlag;

    /**
     * 杉德系统流水号
     */
    private String sandSerial;

    /**
     * 交易日期
     */
    private String tranDate;

    /**
     * 手续费
     */
    private String tranFee;

    /**
     * 额外手续费，配资付款成功才返回，单位为分
     */
    private String extraFee;

    /**
     * 节假日手续费，配资付款成功才返回,单位为分
     */
    private String holidayFee;

    /**
     * 请求方保留域
     */
    private String reqReserved;
}