/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.remit.agent.response.remit;

import com.fshows.remit.agent.response.ShandeBizResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * 杉德代付返回接口
 *
 * @author liluqing
 * @version ShandeAgentPayResponse.java, v 0.1 2023-09-20 14:32
 */
@Data
public class ShandeAgentPayQueryResponse extends ShandeBizResponse implements Serializable {

    private static final long serialVersionUID = 2781695855884327450L;

    /**
     * 交易时间
     */
    private String tranTime;

    /**
     * 订单号
     */
    private String orderCode;

    /**
     * 原交易响应码
     */
    private String origRespCode;

    /**
     * 原交易响应描述
     */
    private String origRespDesc;

    /**
     * 结果状态
     * 0-成功 1-失败 2-处理中
     * （查询到有效订单时返回）
     */
    private String resultFlag;

    /**
     * 杉德系统流水号
     * 杉德前置系统状态为终态，无该字段；
     * 杉德前置系统状态未明，需转发查询处理，会响应该字段
     */
    private String sandSerial;

    /**
     * 交易日期
     */
    private String tranDate;

    /**
     * 手续费
     */
    private String tranFee;

    /**
     * 额外手续费
     */
    private String extraFee;

    /**
     * 节假日手续费
     */
    private String holidayFee;

    /**
     * 退汇标识
     * 1表示有退汇
     */
    private String exchangeRefundStatus;

    /**
     * 退汇描述
     * 示例;20210507/账号户名不符
     */
    private String exchangeRefundReason;
}