/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.remit.agent.request.remit;

import com.fshows.remit.agent.request.ShandeBizRequest;
import com.fshows.remit.agent.response.remit.ShandeAgentPayQueryResponse;
import com.fshows.shande.sdk.request.ShandeRequest;
import lombok.Data;

import java.io.Serializable;

/**
 * 代付接口请求参数
 *
 * @author liluqing
 * @version ShandeAgentPayRequest.java, v 0.1 2023-09-20 14:24
 */
@Data
public class ShandeAgentPayQueryRequest extends ShandeBizRequest<ShandeAgentPayQueryResponse> implements Serializable {

    private static final long serialVersionUID = 2781695855884327450L;

    /**
     * 版本号
     */
    private String version = "01";

    /**
     * 产品ID
     * 付款对私：00000004
     * 付款对公：00000003
     */
    private String productId;

    /**
     * 交易时间,格式：yyyyMMddHHmmss
     */
    private String tranTime;

    /**
     * 订单号,合作商户唯一，建议订单号中包含日期
     */
    private String orderCode;

    /**
     * 扩展域
     */
    private String extend;

    @Override
    public Class<ShandeAgentPayQueryResponse> getResponseClass() {
        return ShandeAgentPayQueryResponse.class;
    }
}
