/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.remit.agent.common;


import com.fshows.com.shande.openapi.sdk.constant.RequestVerifyTypeEnum;
import com.fshows.remit.agent.request.remit.ShandeAgentPayQueryRequest;
import com.fshows.remit.agent.request.remit.ShandeAgentPayRequest;
import com.fshows.remit.agent.response.remit.ShandeAgentPayQueryResponse;
import com.fshows.remit.agent.response.remit.ShandeAgentPayResponse;
import org.apache.commons.lang3.StringUtils;

/**
 * shande api 枚举
 *
 * @author linzy
 * @version ShandeApiEnum.java, v 0.1 2022-12-02 10:33 linzy
 */
public enum ShandeAgentRemitApiEnum {
    /**
     * 进件相关
     */
    AGENT_REMIT("实时付款接口（代扣发起）",
            "/openapi/agentpay",
            "RTPM",
            ShandeAgentPayRequest.class, ShandeAgentPayResponse.class),
    AGENT_REMIT_QUERY("实时付款结果查询",
            "/openapi/queryOrder",
            "ODQU",
            ShandeAgentPayQueryRequest.class, ShandeAgentPayQueryResponse.class),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口子路径
     */
    private String value;
    /**
     * 交易码
     * 见https://open.sandpay.com.cn/product/detail/43996//
     * @see
     */
    private String transCode;
    /**
     * 请求参数类型
     */
    private Class requestClass;
    /**
     * 响应参数类型
     */
    private Class responseClass;

    ShandeAgentRemitApiEnum(String name, String value, String transCode, Class requestClass, Class responseClass) {
        this.name = name;
        this.value = value;
        this.transCode = transCode;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static ShandeAgentRemitApiEnum getByValue(String value) {
        ShandeAgentRemitApiEnum[] valueList = ShandeAgentRemitApiEnum.values();
        for (ShandeAgentRemitApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    public Class getRequestClass() {
        return requestClass;
    }

    public Class getResponseClass() {
        return responseClass;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    public String getTransCode() {
        return transCode;
    }

}
