/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.remit.agent.common;

import cn.hutool.crypto.SecureUtil;
import com.fshows.com.shande.openapi.sdk.enums.SignTypeEnum;
import lombok.Data;

import java.security.PrivateKey;
import java.security.PublicKey;

/**
 *
 * @author liluqing
 * @version RemitClientConfig.java, v 0.1 2023-09-20 15:12
 */
@Data
public class RemitClientConfig {


    /**
     * 网关地址
     */
    private String baseUrl;

    /**
     * 杉德mid
     */
    private String mid;

    /**
     * 平台接入必填，商户接入为空
     */
    private String plId;

    /**
     * 杉德公钥
     */
    private String shandePublicKey;

    /**
     * 付呗私钥
     */
    private String fubeiPrivateKey;

    /**
     * 0-商户接入，默认   1-平台接入
     */
    private String accessType = "0";

    /**
     * 字符集编码
     */
    private String charset = "UTF-8";

    /**
     * 超时时间
     */
    private Integer timeout = 8000;

    /**
     * 签名算法
     */
    private SignTypeEnum signTypeEnum = SignTypeEnum.SHA1WithRSA;

    /**
     * 公钥
     */
    private PublicKey publicKey;

    /**
     * 私钥
     */
    private PrivateKey privateKey;

    public void init() {
        this.publicKey = SecureUtil.generatePublicKey("SHA1WithRSA", SecureUtil.decode(this.getShandePublicKey()));
        this.privateKey = SecureUtil.generatePrivateKey("SHA1WithRSA", SecureUtil.decode(this.getFubeiPrivateKey()));
    }
}