package com.fshows.com.shande.openapi.sdk.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.Set;

public class JsonHumpLineUtils {
    /*
     * 递归驼峰json 转化下划线json
     */
    public static JSONObject transfer(String json) {
        JSONObject objTem = JSON.parseObject(json);
        return transHump(objTem);
    }

    /*
     * 递归Json驼峰转下划线json
     * */
    public static JSONObject transLine(JSONObject objTem) {
        JSONObject jsonObject = new JSONObject();
        Set<String> keySet = objTem.keySet();
        for (String key : keySet) {
            Object objR = objTem.get(key);
            Class type = objR.getClass();
            String express = ExpressUtils.getExpress(ExpressUtils.classLists());
            if (ExpressUtils.judge(express, type)) {
                jsonObject.put(HumpLineUtils.transline(key, "Lower"), objR);
                continue;
            }
            if (objR instanceof JSONObject) {
                JSONObject deal = transLine((JSONObject) objR);
                jsonObject.put(HumpLineUtils.transline(key, "Lower"), deal);
                continue;
            }
            if (objR instanceof JSONArray) {
                JSONArray jsonA = new JSONArray();
                JSONArray jsonArray = objTem.getJSONArray(key);
                for (int i = 0; i < jsonArray.size(); i++) {
                    JSONObject jsonDeal = transLine(jsonArray.getJSONObject(i));
                    jsonA.add(jsonDeal);
                }
                jsonObject.put(HumpLineUtils.transline(key, "Lower"), jsonA);
            }
        }
        return jsonObject;
    }

    /*
     * 递归下划线Json转驼峰json
     * */
    private static JSONObject transHump(JSONObject objTem) {
        JSONObject jsonObject = new JSONObject();
        Set<String> keySet = objTem.keySet();
        for (String key : keySet) {
            Object objR = objTem.get(key);
            Class type = objR.getClass();
            String express = ExpressUtils.getExpress(ExpressUtils.classLists());
            if (ExpressUtils.judge(express, type)) {
                jsonObject.put(HumpLineUtils.transHump(key), objR);
                continue;
            }
            if (objR instanceof JSONObject) {
                JSONObject deal = transHump((JSONObject) objR);
                jsonObject.put(HumpLineUtils.transHump(key), deal);
                continue;
            }
            if (objR instanceof JSONArray) {
                JSONArray jsonA = new JSONArray();
                JSONArray jsonArray = objTem.getJSONArray(key);
                for (int i = 0; i < jsonArray.size(); i++) {
                    JSONObject jsonDeal = transHump(jsonArray.getJSONObject(i));
                    jsonA.add(jsonDeal);
                }
                jsonObject.put(HumpLineUtils.transHump(key), jsonA);
            }
        }
        return jsonObject;
    }
}