package com.fshows.com.shande.openapi.sdk.constant;

/**
 * 文件状态枚举
 *
 * @author miwenming
 * @date 2020/5/25 17:01
 */
public enum FileDownloadStatusEnum {
    DEALING("0", "文件暂未生成，请稍后重试"),
    SUCCESS("1", "文件下载成功"),
    EXCEPTION("2", "文件下载异常，请重新发起生成文件的交易"),
    DELETED("3", "下载的文件已过期或者不存在"),
    NO_RIGHTS("4", "没有下载该文件的权限"),
    OTHER("9", "返回的文件状态未知");

    /**
     * 文件状态
     */
    private String status;
    /** 状态中文信息 */
    private String message;

    FileDownloadStatusEnum(String status, String message) {
        this.status = status;
        this.message = message;
    }

    public String getStatus() {
        return status;
    }

    public String getMessage() {
        return message;
    }
}
