package com.fshows.com.shande.openapi.sdk.constant;

/**
 * 算法类型枚举
 *
 * @author miwenming
 * @date 2020/5/21 19:42
 */
public enum AlgorithmTypeEnum {
    /**
     * 软件加密服务
     */
    RSA_SOFTWARE("RSA"),

    /** 硬件加密服务 */
    RSA_HARDWARE("RSAV2"),

    /** AES-ECB加解密 */
    AES_ECB("RSA"),

    /** AES-CBC加解密 */
    AES_CBC("RSAV2");

    private String algorithmType;

    AlgorithmTypeEnum(String algorithmType) {
        this.algorithmType = algorithmType;
    }

    public String getAlgorithmType() {
        return algorithmType;
    }

}
