package com.fshows.com.shande.openapi.sdk.config;

import com.fshows.com.shande.openapi.sdk.constant.AlgorithmTypeEnum;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

/**
 * 抽象参数配置
 *
 * @author tangjunmao
 * @date 2018/10/18
 */
public abstract class Configuration {

    private static final int TIMEOUT_DEFAULT = 300_000;

    /**
     * 衫德银行接口调用地址，默认生产环境
     * <p>
     * 测试环境：http://cfpaytest.mixienet.com.cn/api/gateway
     * 生产环境：http://cfpay.mixienet.com.cn/api/gateway
     */
    public abstract String remoteAddress();

    /**
     * 建立连接的超时时间，单位：毫秒
     */
    public int connectionTimeout() {
        return TIMEOUT_DEFAULT;
    }

    /**
     * 建立连接后，读取返回数据的超时时间，单位：毫秒
     */
    public int readTimeout() {
        return TIMEOUT_DEFAULT;
    }

    /**
     * 字符集， 默认UTF-8
     */
    public Charset charset() {
        return StandardCharsets.UTF_8;
    }

    /**
     * 签名、验签算法类型，默认为硬件签名
     */
    public String signType() {
        return AlgorithmTypeEnum.RSA_SOFTWARE.getAlgorithmType();
    }

    /**
     * 加解密算法类型，默认AES-CBC
     */
    public String encryptType() {
        return AlgorithmTypeEnum.AES_ECB.getAlgorithmType();
    }

    /**
     * 杉德开户开放平台RSA公钥
     */
    public abstract String shandeAccountOpeningEncPubKey();
    /**
     * 杉德交易出金开放平台RSA公钥
     */
    public abstract String shandeOutFundEncPubKey();

    /**
     * 付呗公钥
     */
    public abstract String fubeiSignPubKey();


    /**
     * 付呗开户加签私钥
     */
    public abstract String fubeiAccountOpeningSignPrivateKey();

    /**
     * 付呗出金加签私钥
     */
    public abstract String fubeiOutFundSignPrivateKey();

    /**
     * 商户号
     */
    public abstract String mid();

    /**
     * 是否进行参数校验
     *
     * @return
     */
    public Boolean checkParam() {
        return true;
    }
}
