package com.fshows.shande.sdk.response.fund.item;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Map;

/**
 * @author liangyuanping
 * @version ShandeTransferParamItemResponse.java, v 0.1 2022-12-06 11:21 AM
 */
@Data
public class ShandeTransferParamItemResponse implements Serializable {

    /**
     * 分账订单子订单 系统订单号
     * 分账批次的唯一单号，由系统生成的唯一单号
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "transferResults[*][transferId]长度不能超过19")
    private String transferId;

    /**
     * 分账订单平台订单号
     * 平台的唯一请求单号，同请求参数
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 64, message = "transferResults[*][outOrderNo]长度不能超过64")
    private String outOrderNo;

    /**
     * 付款电子账簿 ID
     * 付款用户的电子账簿ID
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "transferResults[*][payBalanceAcctId]长度不能超过19")
    private String payBalanceAcctId;

    /**
     * 收款电子账簿 ID
     * 收款用户的电子账簿ID
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 19, message = "transferResults[*][recvBalanceAcctId]长度不能超过19")
    private String recvBalanceAcctId;

    /**
     * 金额
     * 单位为分，要求不能带小数点
     *
     * (必填)
     */
    @NotNull
    private Integer amount;

    /**
     * 交易状态
     * succeeded: 成功processing: 处理中failed: 失败
     *
     * (特殊必填)
     */
    @Length(max = 10, message = "transferResults[*][status]长度不能超过10")
    private String status;

    /**
     * 失败原因
     * 失败时的具体错误原因描述
     *
     * (特殊必填)
     */
    @Length(max = 200, message = "transferResults[*][reason]长度不能超过200")
    private String reason;

    /**
     * 创建时间
     * 格式: RFC3339
     *
     * (必填)
     */
    @NotBlank
    @Length(max = 32, message = "transferResults[* ][createdAt]长度不能超过32")
    private String createdAt;

    /**
     * 处理完成时间
     * 格式: RFC3339
     *
     * (特殊必填)
     */
    @Length(max = 32, message = "transferResults[* ][finishedAt]长度不能超过32")
    private String finishedAt;

    /**
     * 备注
     * 备注信息
     *
     * (选填)
     */
    @Length(max = 255, message = "transferResults[* ][remark]长度不能超过255")
    private String remark;

    /**
     * 预留扩展字段
     * [extra][product_infos] {@link ShandeProductInfoItemResponse}
     */
    private Map<String, Object> extra;

    /**
     * 自定义参数
     * {"purpose":"123456"}
     * <p>
     * (选填)
     */
    private Map<String, String> metadata;
}